set foreign_key_checks=0;

CREATE TABLE document_types (
  id bigint(20) NOT NULL AUTO_INCREMENT,
  itemCode varchar(255) NOT NULL,
  itemValue varchar(255) NOT NULL,
  lastUpdatedBy bigint(20) NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
);


CREATE TABLE completion_required_documents (
  id bigint(20) NOT NULL AUTO_INCREMENT,
  requiredDocumentId bigint(20) NOT NULL,
  completionId bigint(20) NOT NULL,
  whetherSubmitted TINYINT(1) NULL DEFAULT NULL,
  lastUpdatedBy bigint(20) NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id)
) ;



ALTER TABLE document_types	
	ADD CONSTRAINT Refusers3056 FOREIGN KEY (lastUpdatedBy) REFERENCES users (id);
  
ALTER TABLE completion_required_documents	
	ADD CONSTRAINT Refusers3156 FOREIGN KEY (lastUpdatedBy) REFERENCES users (id);
	
ALTER TABLE completion_required_documents
	ADD CONSTRAINT FK_completion_required_documents_document_types FOREIGN KEY (requiredDocumentId) REFERENCES document_types (id);
	
ALTER TABLE completion_required_documents
	ADD CONSTRAINT FK_completion_required_documents_completions FOREIGN KEY (completionId) REFERENCES completions (id);
	

ALTER TABLE documents
	ADD COLUMN documentTypeId BIGINT(20) NULL AFTER createdBy,
	ADD CONSTRAINT FK_documents_document_types FOREIGN KEY (documentTypeId) REFERENCES document_types (id);
	
set foreign_key_checks=1;	