DROP VIEW IF EXISTS `pnc_dashboard_top_and_bottom_attendance_student_wise`;
CREATE VIEW `pnc_dashboard_top_and_bottom_attendance_student` AS
 select     
        programs.id as programId,
        batches.id as batchId,
        prog_batch_period_config.id as periodId,
        sections.id as sectionId,
        admission.code as studentId,
        users.printName as studentName,
        programs.programNameToBePrint as programName,
        batches.batchName,        
        `student_attendance_dashboard_student_wise`.`academyLocationId` AS `academyLocationId`,
        `student_attendance_dashboard_student_wise`.`admissionId` AS `admissionId`,
        sum(`student_attendance_dashboard_student_wise`.`presentRecords`) AS `presentReocrds`,
        sum(`student_attendance_dashboard_student_wise`.`absentRecords`) AS `absentReocrds`,
        sum(`student_attendance_dashboard_student_wise`.`totalRecords`) AS `totalReocrds`,
        round(((sum(`student_attendance_dashboard_student_wise`.`presentRecords`) / sum(`student_attendance_dashboard_student_wise`.`totalRecords`)) * 100),
                0) AS `presentPercentage`,
        round(((sum(`student_attendance_dashboard_student_wise`.`absentRecords`) / sum(`student_attendance_dashboard_student_wise`.`totalRecords`)) * 100),
                0) AS `absentPercentage`
    from
        `student_attendance_dashboard_student_wise`
    left join admission on  student_attendance_dashboard_student_wise.admissionId = admission.id
    left join programs on programs.id = admission.programId
    left join users on admission.studentId = users.id
    left join batches on admission.batchId = batches.id
    left join prog_batch_period_config on prog_batch_period_config.programBatchId = batches.id
    left join sections on sections.periodId = prog_batch_period_config.id
    group by `student_attendance_dashboard_student_wise`.`admissionId`;