CREATE TABLE `examination_repetition` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admissionId` bigint(20) NOT NULL,
  `courseId` bigint(20) NOT NULL,
  `courseVarientId` bigint(20) DEFAULT NULL,
  `courseCompletionStatus` varchar(45) DEFAULT NULL COMMENT 'pass/fail',
  `repetitionFor` varchar(45) DEFAULT NULL COMMENT 'Course / Evaluation',
  `repetitionType` varchar(45) DEFAULT NULL COMMENT 'Complete / Partial',
  `courseComponentId` bigint(20) DEFAULT NULL,
  `evalDetailSeqId` bigint(20) DEFAULT NULL,
  `feePlanRuleStageId` bigint(20) DEFAULT NULL,
  `remarks` text,
  `repetitionCourseVariantId` bigint(20) DEFAULT NULL,
  `approvalStatus` varchar(45) DEFAULT NULL COMMENT 'Pending/Approved',
  `approvedById` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refasmission2342_idx` (`admissionId`),
  KEY `Refcourse980_idx` (`courseId`),
  KEY `Refcoursevariant98_idx` (`courseVarientId`),
  KEY `Refcoursecomponent768_idx` (`courseComponentId`),
  KEY `Refdetailsequence879_idx` (`evalDetailSeqId`),
  KEY `Refrepetitingcoursevariant434_idx` (`repetitionCourseVariantId`),
  KEY `Reflastupdatereoetition653_idx` (`lastUpdatedBy`),
  KEY `Reffeeplanrulestage78_idx` (`feePlanRuleStageId`),
  KEY `RefapprovedBy4345_idx` (`approvedById`),
  CONSTRAINT `Refasmission2342` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refcourse980` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refcoursecomponent768` FOREIGN KEY (`courseComponentId`) REFERENCES `course_components` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refcoursevariant98` FOREIGN KEY (`courseVarientId`) REFERENCES `course_variants` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refdetailsequence879` FOREIGN KEY (`evalDetailSeqId`) REFERENCES `eval_seq_detail` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Reffeeplanrulestage78` FOREIGN KEY (`feePlanRuleStageId`) REFERENCES `fee_plan_rule_stage` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Reflastupdatereoetition653` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
