CREATE TABLE `enq_intermediate_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL,
  `whetherDefault` bit(1) NOT NULL DEFAULT b'0',
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type_UNIQUE` (`type`),
  KEY `fk_enq_intermediate_type_user_id_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_enq_intermediate_type_user_id` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- adding all record in enq_intermediate_type
INSERT INTO `enq_intermediate_type` 
(`type`, `whetherDefault`, `lastUpdatedBy`, `lastUpdate`) VALUES ('Unassigned', 1, '1', sysdate());

INSERT INTO `enq_intermediate_type` 
(`type`, `whetherDefault`, `lastUpdatedBy`, `lastUpdate`) VALUES ('Genuine', 0, '1', sysdate());

INSERT INTO `enq_intermediate_type` 
(`type`, `whetherDefault`, `lastUpdatedBy`, `lastUpdate`) VALUES ('Assigned to Call center', 0, '1', sysdate());

INSERT INTO `enq_intermediate_type` 
(`type`, `whetherDefault`, `lastUpdatedBy`, `lastUpdate`) VALUES ('Interested in Enrolment', 0, '1', sysdate());

INSERT INTO `enq_intermediate_type` 
(`type`, `whetherDefault`, `lastUpdatedBy`, `lastUpdate`) VALUES ('Application Sent', 0, '1', sysdate());

INSERT INTO `enq_intermediate_type` 
(`type`, `whetherDefault`, `lastUpdatedBy`, `lastUpdate`) VALUES ('Application Submitted', 0, '1', sysdate());

INSERT INTO `enq_intermediate_type` 
(`type`, `whetherDefault`, `lastUpdatedBy`, `lastUpdate`) VALUES ('Enrolled', 0, '1', sysdate());


INSERT INTO `enq_intermediate_type` 
(`type`, `whetherDefault`, `lastUpdatedBy`, `lastUpdate`) VALUES ('Withdrawn', 0, '1', sysdate());

INSERT INTO `enq_intermediate_type` 
(`type`, `whetherDefault`, `lastUpdatedBy`, `lastUpdate`) VALUES ('Completed', 0, '1', sysdate());


-- add a new field
ALTER TABLE `enquiry` 
ADD COLUMN `enqIntermediateStageId` BIGINT(20) NOT NULL AFTER `categoryField5`;


-- upadte the enq followup
update enquiry set enqIntermediateStageId=1 where id!=0;

-- query to change add column in folow_up table and make it FK, before we need to add one default record and make it as FK
ALTER TABLE `enquiry` 
ADD CONSTRAINT `fk_enquiry_enqintstage`
  FOREIGN KEY (`enqIntermediateStageId`)
  REFERENCES `enq_intermediate_type` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master(`id`, `tableName`, `masterName`, `whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
 VALUES (@standardMasterMaxId + 1, 'enq_intermediate_type', 'ENQUIRY_INTERMEDIATE_TYPE', 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
 VALUES (@ItemsMaxId + 1, 'type', 'TYPE', @standardMasterMaxId + 1, 'varchar', '1', 0, 0, 0, 1, '1', SYSDATE());

SET @ItemsMaxId = @ItemsMaxId + 2;
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
 VALUES (@ItemsMaxId, 'whetherDefault', 'WHETHER_DEFAULT', @standardMasterMaxId + 1, 'Boolean', '2', 0,0, 0, 1, '1', SYSDATE());

