drop view if exists `campaign_report`;

CREATE VIEW `campaign_report` AS
select `campaign`.`id` AS `campaignId`,`campaign`.`code` AS `campaignCode`,`campaign`.`campaignName` AS `campaignName`,
`campaign`.`fromDate` AS `fromDate`,`campaign`.`toDate` AS `toDate`,datediff(curdate() , `campaign`.`fromDate`) AS `noOfDayActive`,
 datediff(`campaign`.`toDate` , `campaign`.`fromDate`) AS `totalDuration`,

if(`campaign`.`actualAmount` is null,`campaign`.`budgetAmount`,`campaign`.`actualAmount`) AS `costCampaign`,
count(`enquiry`.`id`) AS `totalEnquiry`,count(`application`.`id`) AS `noOfApplications`,
(select count(distinct `academies`.`id`) from `campaign_coverage`
left join `academy_location` ON `academy_location`.id = `campaign_coverage`.academyLocationId
left join `academies` ON `academy_location`.`academyId` = `academies`.`id`
left join `campaign` `cmp` ON `campaign_coverage`.`campaignId` = `cmp`.`id`
 where `cmp`.`id` = `campaign`.`id` group by `campaign_coverage`.`campaignId`) AS `academiesCovered`,

(select count(distinct `locations`.`id`) from `campaign_coverage` 
left join `academy_location` on `campaign_coverage`.`academyLocationId` = `academy_location`.`id`
left join `locations` ON `academy_location`.`locationId` = `locations`.`id`
left join `campaign` `cmp` ON `campaign_coverage`.`campaignId` = `cmp`.`id`
where `cmp`.`id` = `campaign`.`id` group by `campaign_coverage`.`campaignId`) AS `locationsCovered`,
(select count(distinct `programs`.`id`) from `campaign_coverage`
left join `programs` ON `campaign_coverage`.`programId` = `programs`.`id`
left join `campaign` `cmp` ON `campaign_coverage`.`campaignId` = `cmp`.`id`
where `cmp`.`id` = `campaign`.`id` group by `campaign_coverage`.`campaignId`) AS `programsCovered`,
(`campaign`.`actualAmount` / count(`enquiry`.`id`)) AS `costPerEnquiry`,

(select count(distinct `application`.`enquiryStudentDetailId`)from
`application` left join `enq_student_details` ON `application`.`enquiryStudentDetailId` = `enq_student_details`.`id`
left join `enquiry` ON `enq_student_details`.`enquiryId` = `enquiry`.`id`
left join `campaign` `camp` ON `enquiry`.`campaignId` = `camp`.`id`
where `camp`.`id` = `campaign`.`id` and `application`.`currentStatus` = 'ADMISSION_GRANTED') AS `studentAdmitted`,

(select count(distinct `application`.`enquiryStudentDetailId`)
from `application`
left join `enq_student_details` ON `application`.`enquiryStudentDetailId` = `enq_student_details`.`id`
left join `enquiry` ON `enq_student_details`.`enquiryId` = `enquiry`.`id`
left join `campaign` `camp` ON `enquiry`.`campaignId` = `camp`.`id`
left join `application_program` ON `application`.`id` = `application_program`.`applicationId`
where `camp`.`id` = `campaign`.`id` and `application_program`.`currentStatus` = 'OFFER_LETTER_ACCEPTED'
and `application`.`currentStatus` != 'ADMISSION_GRANTED') AS `studentSelected`,

if((select count(distinct `application`.`enquiryStudentDetailId`)
from `application` left join `enq_student_details` ON `application`.`enquiryStudentDetailId` = `enq_student_details`.`id`
left join `enquiry` ON `enq_student_details`.`enquiryId` = `enquiry`.`id`
left join `campaign` `camp` ON `enquiry`.`campaignId` = `camp`.`id`
where `campaign`.`id` = `camp`.`id` and `application`.`currentStatus` = 'ADMISSION_GRANTED' = 0),
(select if(`campa`.`actualAmount` is null,`campa`.`budgetAmount`,`campa`.`actualAmount`)
from `campaign` `campa` where `campaign`.`id` = `campa`.`id`),
(select if(`campa`.`actualAmount` is null,`campa`.`budgetAmount`,`campa`.`actualAmount`)
from `campaign` `campa` where `campaign`.`id` = `campa`.`id`) / (select 
count(distinct `application`.`enquiryStudentDetailId`)from `application`
left join `enq_student_details` ON `application`.`enquiryStudentDetailId` = `enq_student_details`.`id`
left join `enquiry` ON `enq_student_details`.`enquiryId` = `enquiry`.`id`
left join `campaign` `camp` ON `enquiry`.`campaignId` = `camp`.`id`
where `campaign`.`id` = `camp`.`id`
and `application`.`currentStatus` = 'ADMISSION_GRANTED')) AS `costPerAdmission`

from `enquiry`
left join `campaign` ON `enquiry`.`campaignId` = `campaign`.`id`
left join `enq_student_details` ON `enquiry`.`id` = `enq_student_details`.`enquiryId`
left join `application` ON `enq_student_details`.`id` = `application`.`enquiryStudentDetailId`
left join `admission_enq_details` ON `enq_student_details`.`id` = `admission_enq_details`.`enqStudentDetailsId`
where `campaign`.`whetherDeleted` = 0 group by `campaign`.`id`
order by `campaign`.`fromDate`;