DROP TABLE IF EXISTS student_hw_file_download;
DROP TABLE IF EXISTS student_hw_file_upload;

CREATE TABLE `group_hw_assignment_documents` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `groupHomeworkAssignmentId` bigint(20) NOT NULL,
  `documentId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_group_hw_assignment_documents_1_idx` (`groupHomeworkAssignmentId`),
  KEY `fk_group_hw_assignment_documents_2_idx` (`documentId`),
  KEY `fk_group_hw_assignment_documents_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_group_hw_assignment_documents_1` 
	FOREIGN KEY (`groupHomeworkAssignmentId`) REFERENCES `group_hw_assignment` (`id`),
  CONSTRAINT `fk_group_hw_assignment_documents_2` 
	FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`),
  CONSTRAINT `fk_group_hw_assignment_documents_3` 
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);

