CREATE TABLE `batch_courses` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `batchId` bigint(20) NOT NULL,
  `courseId` bigint(20) NOT NULL,
  `courseGroupId` bigint(20) DEFAULT NULL,
  `whetherOptional` bit(1) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `index2` (`batchId`,`courseId`),
  KEY `fk_program_batch_courses_2_idx` (`courseId`),
  KEY `fk_program_batch_courses_3_idx` (`courseGroupId`),
  KEY `fk_program_batch_courses_4_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_program_batch_courses_1` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`),
  CONSTRAINT `fk_program_batch_courses_2` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`),
  CONSTRAINT `fk_program_batch_courses_3` FOREIGN KEY (`courseGroupId`) REFERENCES `course_group` (`id`),
  CONSTRAINT `fk_program_batch_courses_4` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);
