-- Added a new table to define enquiry priority
CREATE TABLE `enq_priority` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `priority` varchar(45) NOT NULL,
  `whetherDefault` bit(1) NOT NULL DEFAULT b'0',
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `priority_UNIQUE` (`priority`),
  KEY `fk_enq_priority_userid_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_enq_priority_userid` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- inserting the default value into enquiry priority
INSERT INTO `enq_priority` VALUES (1,'High','','2014-08-18 13:32:28',1),
(2,'Low','\0','2014-08-18 13:32:47',1),
(3,'Medium','\0','2014-08-18 13:32:57',1);

-- adding standard master entry for enquiry priority
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master(`id`, `tableName`, `masterName`, `whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
 VALUES (@standardMasterMaxId + 1, 'enq_priority', 'ENQUIRY_PRIORITY', 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`,  
  `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, 
  `lastUpdatedBy`, `lastUpdate`) 
 VALUES (@ItemsMaxId + 1, 'priority', 'PRIORITY', @standardMasterMaxId + 1, 'varchar', '1', 0, NULL, NULL, NULL, 0, 0, 0, '1', SYSDATE());


SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`,  
  `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, 
  `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId + 1, 'whetherDefault', 'IS_DEFAULT', @standardMasterMaxId + 1, 'Boolean', '2', 0, NULL, NULL, NULL, 0, 0, 0, '1', SYSDATE());
