drop table if exists `designations`; 
CREATE TABLE `designations` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`lastUpdate` DATETIME NOT NULL,
	`itemCode` VARCHAR(10) NULL DEFAULT NULL,
	`itemValue` VARCHAR(100) NULL DEFAULT NULL,
	`lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (`id`),
	UNIQUE INDEX `id` (`id`),
	INDEX `FK7F4F1F5CED259864` (`lastUpdatedBy`),
	CONSTRAINT `FK7F4F1F5CED259864` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);

  CREATE TABLE `faculty_profile` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`lastUpdate` DATETIME NOT NULL,
	`version` BIGINT(20) NOT NULL,
	`facultyId` BIGINT(20) NOT NULL,
	`isFilled` TINYINT(1) NOT NULL,
	`isMandatory` TINYINT(1) NOT NULL,
	`tabName` VARCHAR(255) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
	PRIMARY KEY (`id`),
	UNIQUE INDEX `id` (`id`),
	INDEX `FK338B26CEED259864` (`lastUpdatedBy`),
	CONSTRAINT `FK338B26CEED259864` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);

SET FOREIGN_KEY_CHECKS=0;

ALTER TABLE `faculties`
CHANGE COLUMN `designation` `designationId` BIGINT(20) NOT NULL AFTER `facultyCode`,
CHANGE COLUMN `yearsOfExperience` `yearsOfExperience` INT(10) NULL AFTER `exitDate`,
  ADD CONSTRAINT `faculties_designation` FOREIGN KEY (`designationId`) REFERENCES `designations` (`id`);
  
  SET FOREIGN_KEY_CHECKS=1;