/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.CriteriaBuilderConfigurer;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class AcademiaPropertiesLoader {
    public static final Path OUTPUT_DIRECTORY_PATH = Paths.get(System.getenv("ACADEMIA_PROPERTIES"), new String[0]);
    private static final Logger logger = Logger.getLogger(AcademiaPropertiesLoader.class);

    @Bean
    public PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        logger.info("Loading properties ...");
        PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer = new PropertySourcesPlaceholderConfigurer();
        propertySourcesPlaceholderConfigurer.setLocations(this.getResources());
        logger.info("Properties file loaded successfully...");
        return propertySourcesPlaceholderConfigurer;
    }

    public Resource[] getResources() {
        List<Object> resourceList = new ArrayList();
        List files = null;
        try {
            files = Files.list(OUTPUT_DIRECTORY_PATH).map(Path::toFile).filter(path -> path.toString().endsWith(".properties")).filter(File::isFile).collect(Collectors.toList());
            resourceList = files.stream().map(data -> new FileSystemResource(data.getPath())).collect(Collectors.toList());
        }
        catch (IOException ioe) {
            logger.error("Reading properties files :" + ioe.getStackTrace());
        }
        return resourceList.toArray(new Resource[0]);
    }
}

