/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.cb.dao.impl;

import in.serosoft.cb.dao.SearchTableColumnDAO;
import in.serosoft.cb.dao.impl.CBGenericDAOImpl;
import in.serosoft.cb.entity.SearchTableColumn;
import in.serosoft.cb.model.CustomField;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="searchTableColumnDAO")
public class SearchTableColumnDAOImpl
extends CBGenericDAOImpl<SearchTableColumn, Long>
implements SearchTableColumnDAO {
    public SearchTableColumnDAOImpl() {
        super(SearchTableColumn.class);
    }

    @Override
    public List<SearchTableColumn> findSearchTableColumns(List<Long> ids) {
        Criteria criteria = this.getCriteria(SearchTableColumn.class);
        criteria.add(Restrictions.in("id", ids));
        return criteria.list();
    }

    @Override
    public Long findSearchTableColumnIdByColumnName(Long searchTableId, String columnName) {
        Criteria criteria = this.getCriteria();
        criteria.setProjection(Projections.property("id"));
        criteria.add(Restrictions.eq("searchTable.id", searchTableId));
        criteria.add(Restrictions.eq("columnName", columnName));
        return (Long)criteria.uniqueResult();
    }

    @Override
    public void updateCBCustomField(CustomField customField) {
        try {
            String sql = "UPDATE `search_table_column` INNER JOIN `search_table` ON `search_table`.id=`search_table_column`.`searchTableId` SET `search_table_column`.`displayCode`= '" + StringEscapeUtils.escapeSql(customField.getDisplayName()) + "',`search_table_column`.`tableColumnReff`='" + StringEscapeUtils.escapeSql(customField.getTableColumnReff()) + "',`search_table_column`.`customFieldConfigId`=" + customField.getCustomFieldConfigId() + " , `search_table_column`.`whetherOccupied`=TRUE , `search_table_column`.`whetherSimpleCatagory`=" + customField.getWhetherSimpleCatagory() + " , `search_table_column`.`whetherStandardMaster`=" + customField.getWhetherStandardMaster() + " WHERE `search_table`.`dbTableName`='" + StringEscapeUtils.escapeSql(customField.getTableName()) + "' AND `search_table_column`.`columnName`='" + StringEscapeUtils.escapeSql(customField.getColumnName()) + "'";
            SQLQuery query = this.getCrntSession().createSQLQuery(sql);
            query.executeUpdate();
            sql = "UPDATE `search_result_view_column` INNER JOIN `search_table_column` ON `search_table_column`.id=`search_result_view_column`.`searchTableColumnId` INNER JOIN `search_table` ON `search_table`.id=`search_table_column`.`searchTableId` SET `search_result_view_column`.`displayCode`='" + StringEscapeUtils.escapeSql(customField.getDisplayName()) + "' WHERE `search_table`.`dbTableName`='" + StringEscapeUtils.escapeSql(customField.getTableName()) + "' AND `search_table_column`.`columnName`='" + StringEscapeUtils.escapeSql(customField.getColumnName()) + "'";
            query = this.getCrntSession().createSQLQuery(sql);
            query.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<SearchTableColumn> findBySearchTableId(Long id) {
        Criteria criteria = this.getCriteria(SearchTableColumn.class);
        criteria.add(Restrictions.eq("searchTable.id", id));
        return criteria.list();
    }
}

