/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.cb.entity;

import in.serosoft.cb.entity.SearchResultViewColumn;
import in.serosoft.cb.entity.SearchTable;
import in.serosoft.cb.entity.SearchTableColumn;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="search_aggregation_column")
public class SearchAggregationColumn
implements Serializable {
    private Long id;
    private SearchTableColumn searchTableColumn;
    private SearchTable searchTable;
    private String aliasName;
    private String aggregateFunction;
    private Set<SearchResultViewColumn> searchResultViewColumns = new HashSet<SearchResultViewColumn>(0);

    public SearchAggregationColumn() {
    }

    public SearchAggregationColumn(SearchTableColumn searchTableColumn, SearchTable searchTable, String aliasName, String aggregateFunction) {
        this.searchTableColumn = searchTableColumn;
        this.searchTable = searchTable;
        this.aliasName = aliasName;
        this.aggregateFunction = aggregateFunction;
    }

    public SearchAggregationColumn(SearchTableColumn searchTableColumn, SearchTable searchTable, String aliasName, String aggregateFunction, Set<SearchResultViewColumn> searchResultViewColumns) {
        this.searchTableColumn = searchTableColumn;
        this.searchTable = searchTable;
        this.aliasName = aliasName;
        this.aggregateFunction = aggregateFunction;
        this.searchResultViewColumns = searchResultViewColumns;
    }

    @SequenceGenerator(name="generator", sequenceName="search_aggregation_column_seq")
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="generator")
    @Column(name="id", unique=true, nullable=false)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="searchTableColumnId", nullable=false)
    public SearchTableColumn getSearchTableColumn() {
        return this.searchTableColumn;
    }

    public void setSearchTableColumn(SearchTableColumn searchTableColumn) {
        this.searchTableColumn = searchTableColumn;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="searchTableId", nullable=false)
    public SearchTable getSearchTable() {
        return this.searchTable;
    }

    public void setSearchTable(SearchTable searchTable) {
        this.searchTable = searchTable;
    }

    @Column(name="aliasName", nullable=false, length=50)
    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    @Column(name="aggregateFunction", nullable=false, length=20)
    public String getAggregateFunction() {
        return this.aggregateFunction;
    }

    public void setAggregateFunction(String aggregateFunction) {
        this.aggregateFunction = aggregateFunction;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="searchAggregationColumn")
    public Set<SearchResultViewColumn> getSearchResultViewColumns() {
        return this.searchResultViewColumns;
    }

    public void setSearchResultViewColumns(Set<SearchResultViewColumn> searchResultViewColumns) {
        this.searchResultViewColumns = searchResultViewColumns;
    }
}

