/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.cb.helper;

import in.serosoft.cb.dao.SearchTableColumnDAO;
import in.serosoft.cb.dao.SearchTableRelationDAO;
import in.serosoft.cb.entity.SavedSearch;
import in.serosoft.cb.entity.SavedSearchCriteria;
import in.serosoft.cb.entity.SearchConfig;
import in.serosoft.cb.entity.SearchConfigTable;
import in.serosoft.cb.entity.SearchCriteriaOperator;
import in.serosoft.cb.entity.SearchResultView;
import in.serosoft.cb.entity.SearchTable;
import in.serosoft.cb.entity.SearchTableColumn;
import in.serosoft.cb.entity.SearchTableRelation;
import in.serosoft.cb.enumeration.OperatorEnum;
import in.serosoft.cb.helper.DTOToEntityConvertor;
import in.serosoft.cb.helper.SavedSearchConfigurationHelper;
import in.serosoft.cb.model.SavedSearchCriteriaDTO;
import in.serosoft.cb.model.SavedSearchDTO;
import in.serosoft.cb.model.SavedSearchesDTO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SavedSearchDTOToEntityConvertor {
    private Map<String, Map<String, SearchConfigTable>> searchConfigTablesMap;
    private Map<String, SearchConfig> searchConfigMap;
    private Map<String, SearchResultView> searchResultViewMap;
    private Map<String, SearchTable> searchTablesMap;
    private List<SearchTableRelation> searchTableRelations;
    private SearchTableRelationDAO searchTableRelationDAO;
    private SearchTableColumnDAO searchTableColumnDAO;

    public SavedSearchDTOToEntityConvertor(Map<String, SearchConfig> searchConfigMap, Map<String, SearchResultView> searchResultViewMap, Map<String, Map<String, SearchConfigTable>> searchConfigTablesMap, Map<String, SearchTable> searchTablesMap, List<SearchTableRelation> searchTableRelations, SearchTableRelationDAO searchTableRelationDAO, SearchTableColumnDAO searchTableColumnDAO) {
        this.searchConfigMap = searchConfigMap;
        this.searchResultViewMap = searchResultViewMap;
        this.searchConfigTablesMap = searchConfigTablesMap;
        this.searchTablesMap = searchTablesMap;
        this.searchTableRelations = searchTableRelations;
        this.searchTableRelationDAO = searchTableRelationDAO;
        this.searchTableColumnDAO = searchTableColumnDAO;
    }

    public List<SavedSearch> covertSavedSearchesDTOToSavedSearch(SavedSearchesDTO savedSearchesDTO) {
        ArrayList<SavedSearch> savedSearches = new ArrayList<SavedSearch>();
        List<SavedSearchDTO> savedSearchDTOs = savedSearchesDTO.getSavedSearchDTOs();
        for (SavedSearchDTO savedSearchDTO : savedSearchDTOs) {
            SavedSearch savedSearch = new SavedSearch();
            savedSearch.setId(savedSearchDTO.getId());
            savedSearch.setUserId(savedSearchDTO.getUserId() != null ? savedSearchDTO.getUserId() : 1L);
            savedSearch.setSearchName(savedSearchDTO.getSearchName());
            savedSearch.setModuleName(savedSearchDTO.getModuleName());
            savedSearch.setWhetherPredefined(savedSearchDTO.getWhetherPredefined());
            savedSearch.setSearchConfiguration(this.searchConfigMap.get(savedSearchDTO.getConfigCode()));
            if (!savedSearchDTO.getViewCode().contains("USER_SAVED_VIEW")) {
                savedSearch.setSearchResultView(this.searchResultViewMap.get(savedSearchDTO.getViewCode()));
            } else {
                DTOToEntityConvertor dtoToEntityConvertor = new DTOToEntityConvertor(this.searchTablesMap, this.searchTableRelations, this.searchTableRelationDAO, this.searchTableColumnDAO);
                SearchConfig searchConfig = this.searchConfigMap.get(savedSearchDTO.getConfigCode());
                if (searchConfig != null && searchConfig.getSearchConfigurationTables() != null) {
                    for (SearchConfigTable searchConfigTable : searchConfig.getSearchConfigurationTables()) {
                        dtoToEntityConvertor.searchConfigTablesMap.put(searchConfigTable.getAlias(), searchConfigTable);
                    }
                }
                SearchResultView searchResultView = dtoToEntityConvertor.convertSearchResultViewDTOToSearchResultView(savedSearchDTO.getSearchResultView());
                searchResultView.setSearchConfiguration(searchConfig);
                savedSearch.setSearchResultView(searchResultView);
            }
            SavedSearchCriteriaDTO savedSearchCriteriaDTO = savedSearchDTO.getSavedSearchCriteriaDTO();
            if (savedSearchCriteriaDTO != null) {
                Set<SavedSearchCriteria> savedSearchCriterias = this.buildSavedSearchCriterias(savedSearchCriteriaDTO, savedSearchDTO.getConfigCode(), savedSearch);
                savedSearch.setSavedSearchCriterias(savedSearchCriterias);
            }
            savedSearches.add(savedSearch);
        }
        return savedSearches;
    }

    private Set<SavedSearchCriteria> buildSavedSearchCriterias(SavedSearchCriteriaDTO savedSearchCriteriaDTO, String configCode, SavedSearch parentSavedSearch) {
        SavedSearchCriteria savedSearchCriteria1 = this.buildSavedSearchCriteria(savedSearchCriteriaDTO, configCode, new SavedSearchCriteria());
        savedSearchCriteria1.setSavedSearch(parentSavedSearch);
        HashSet<SavedSearchCriteria> savedSearchCriterias = new HashSet<SavedSearchCriteria>();
        savedSearchCriterias.add(savedSearchCriteria1);
        return savedSearchCriterias;
    }

    private SavedSearchCriteria buildSavedSearchCriteria(SavedSearchCriteriaDTO savedSearchCriteriaDTO, String configCode, SavedSearchCriteria savedSearchCriteria) {
        System.out.println("Saved configCode" + configCode);
        savedSearchCriteria.setLogicalOperator(savedSearchCriteriaDTO.getLogicalOperator());
        savedSearchCriteria.setCriteriaType(savedSearchCriteriaDTO.getCriteriaType());
        HashSet<SavedSearchCriteria> childSavedSearchCriterias = new HashSet<SavedSearchCriteria>();
        List<SavedSearchCriteriaDTO> savedSearchCriteriaDTOs = savedSearchCriteriaDTO.getChildSavedSearchCriteriaDTOs();
        for (SavedSearchCriteriaDTO childSavedSearchCriteriaDTO : savedSearchCriteriaDTOs) {
            SavedSearchCriteria childSavedSearchCriteria = null;
            if (childSavedSearchCriteriaDTO.getCriteriaType().equals("SQL")) {
                childSavedSearchCriteria = this.convertSavedSearchCriteriaDTOToSavedSearchCriteria(childSavedSearchCriteriaDTO, configCode);
                childSavedSearchCriteria.setSavedSearchCriteria(savedSearchCriteria);
                childSavedSearchCriterias.add(childSavedSearchCriteria);
                continue;
            }
            if (childSavedSearchCriteriaDTO.getCriteriaType().equals("LOGICAL")) {
                childSavedSearchCriteria = this.buildSavedSearchCriteria(childSavedSearchCriteriaDTO, configCode, new SavedSearchCriteria());
                childSavedSearchCriteria.setSavedSearchCriteria(savedSearchCriteria);
                childSavedSearchCriterias.add(childSavedSearchCriteria);
                continue;
            }
            childSavedSearchCriterias.add(childSavedSearchCriteria);
        }
        savedSearchCriteria.setSavedSearchCriterias(childSavedSearchCriterias);
        return savedSearchCriteria;
    }

    private SavedSearchCriteria convertSavedSearchCriteriaDTOToSavedSearchCriteria(SavedSearchCriteriaDTO childSavedSearchCriteriaDTO, String configCode) {
        SavedSearchCriteria savedSearchCriteria = new SavedSearchCriteria();
        savedSearchCriteria.setLogicalOperator(childSavedSearchCriteriaDTO.getLogicalOperator());
        savedSearchCriteria.setCriteriaType(childSavedSearchCriteriaDTO.getCriteriaType());
        SearchConfigTable searchConfigTable = SavedSearchConfigurationHelper.findSearchConfigTable(configCode, childSavedSearchCriteriaDTO.getTableName(), this.searchConfigTablesMap);
        savedSearchCriteria.setSearchConfigTable(searchConfigTable);
        SearchTableColumn searchTableColumn = SavedSearchConfigurationHelper.findSearchTableColumn(searchConfigTable, childSavedSearchCriteriaDTO.getColumnName());
        savedSearchCriteria.setSearchTableColumn(searchTableColumn);
        savedSearchCriteria.setSearchCriteriaOperator(this.findSearchCriteriaOperator(this.getPrefix(searchTableColumn) + childSavedSearchCriteriaDTO.getOperatorCode().toUpperCase()));
        savedSearchCriteria.setOperandValue(childSavedSearchCriteriaDTO.getOperandValue());
        return savedSearchCriteria;
    }

    private String getPrefix(SearchTableColumn searchTableColumn) {
        String pref = searchTableColumn.getDataType();
        if (pref.equals("IDENTITY") || pref.equals("REF_IDENTITY")) {
            pref = "NUMBER";
        }
        if (searchTableColumn.getWhetherStandardMaster().booleanValue()) {
            pref = "ENUM";
        }
        return pref + "_";
    }

    private SearchCriteriaOperator findSearchCriteriaOperator(String operatorCode) {
        SearchCriteriaOperator searchCriteriaOperator = new SearchCriteriaOperator();
        searchCriteriaOperator.setId(OperatorEnum.valueOf(operatorCode).getOperatorId());
        return searchCriteriaOperator;
    }
}

