/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.cb.helper;

import in.serosoft.cb.entity.SearchAggregationColumn;
import in.serosoft.cb.entity.SearchResultFormatterParams;
import in.serosoft.cb.entity.SearchResultView;
import in.serosoft.cb.entity.SearchResultViewColumn;
import in.serosoft.cb.entity.SearchSQLGroup;
import in.serosoft.cb.entity.SearchSQLGroupBy;
import in.serosoft.cb.model.SearchAggregateColumnDTO;
import in.serosoft.cb.model.SearchResultFormatterParamsDTO;
import in.serosoft.cb.model.SearchResultViewColumnDTO;
import in.serosoft.cb.model.SearchResultViewDTO;
import in.serosoft.cb.model.SearchSQLGroupByDTO;
import in.serosoft.cb.model.SearchSQLGroupDTO;
import java.util.ArrayList;
import java.util.Set;

public class SearchResultViewEntityToDTOConvertor {
    public SearchResultViewDTO convert(SearchResultView searchResultView) {
        SearchResultViewDTO searchResultViewDTO = new SearchResultViewDTO();
        searchResultViewDTO.setDefaultView(searchResultView.getId());
        searchResultViewDTO.setViewCode(searchResultView.getViewCode());
        searchResultViewDTO.setId(searchResultView.getId());
        ArrayList<SearchResultViewColumnDTO> searchResultViewColumnDTOs = new ArrayList<SearchResultViewColumnDTO>();
        Set<SearchResultViewColumn> searchResultViewColumns = searchResultView.getSearchResultViewColumns();
        if (searchResultViewColumns != null && !searchResultViewColumns.isEmpty()) {
            for (SearchResultViewColumn searchResultViewColumn : searchResultViewColumns) {
                SearchResultViewColumnDTO searchResultViewColumnDTO = this.covertSearchResultViewColumnEntityToDTO(searchResultViewColumn);
                searchResultViewColumnDTOs.add(searchResultViewColumnDTO);
            }
            searchResultViewDTO.setSearchResultViewColumns(searchResultViewColumnDTOs);
        }
        ArrayList<SearchSQLGroupDTO> searchSQLGroupDTOs = new ArrayList<SearchSQLGroupDTO>();
        Set<SearchSQLGroup> searchSQLGroups = searchResultView.getSearchSQLGroups();
        if (searchSQLGroups != null && !searchSQLGroups.isEmpty()) {
            for (SearchSQLGroup searchSQLGroup : searchSQLGroups) {
                SearchSQLGroupDTO searchSQLGroupDTO = this.convertSearchSQLGroupEntityToDTO(searchSQLGroup);
                searchSQLGroupDTOs.add(searchSQLGroupDTO);
            }
            searchResultViewDTO.setSearchSQLGroups(searchSQLGroupDTOs);
        }
        return searchResultViewDTO;
    }

    private SearchSQLGroupDTO convertSearchSQLGroupEntityToDTO(SearchSQLGroup searchSQLGroup) {
        SearchSQLGroupDTO searchSQLGroupDTO = new SearchSQLGroupDTO();
        searchSQLGroupDTO.setGroupName(searchSQLGroup.getGroupName());
        searchSQLGroupDTO.setGroupOrder(searchSQLGroup.getOrder());
        searchSQLGroupDTO.setId(searchSQLGroup.getId());
        ArrayList<SearchSQLGroupByDTO> searchSQLGroupBieDTOs = new ArrayList<SearchSQLGroupByDTO>();
        Set<SearchSQLGroupBy> searchSQLGroupBies = searchSQLGroup.getSearchSQLGroupBies();
        if (searchSQLGroupBies != null && !searchSQLGroupBies.isEmpty()) {
            for (SearchSQLGroupBy searchSQLGroupBy : searchSQLGroupBies) {
                SearchSQLGroupByDTO searchSQLGroupByDTO = this.convertSearchSQLGroupByEntityToDTO(searchSQLGroupBy);
                searchSQLGroupBieDTOs.add(searchSQLGroupByDTO);
            }
            searchSQLGroupDTO.setSearchSQLGroupBies(searchSQLGroupBieDTOs);
        }
        return searchSQLGroupDTO;
    }

    private SearchSQLGroupByDTO convertSearchSQLGroupByEntityToDTO(SearchSQLGroupBy searchSQLGroupBy) {
        SearchSQLGroupByDTO searchSQLGroupByDTO = new SearchSQLGroupByDTO();
        searchSQLGroupByDTO.setId(searchSQLGroupBy.getId());
        searchSQLGroupByDTO.setGroupByOrder(searchSQLGroupBy.getOrder());
        searchSQLGroupByDTO.setSearchResultViewColumn(searchSQLGroupBy.getSearchResultViewColumn().getResultKey());
        return searchSQLGroupByDTO;
    }

    private SearchResultViewColumnDTO covertSearchResultViewColumnEntityToDTO(SearchResultViewColumn searchResultViewColumn) {
        SearchSQLGroup searchSQLGroup;
        SearchResultFormatterParams searchResultFormatterParams;
        SearchResultViewColumnDTO searchResultViewColumnDTO = new SearchResultViewColumnDTO();
        searchResultViewColumnDTO.setDisplayCode(searchResultViewColumn.getDisplayCode());
        searchResultViewColumnDTO.setDisplayOrder(searchResultViewColumn.getDisplayOrder());
        searchResultViewColumnDTO.setFormatter(searchResultViewColumn.getFormatter());
        searchResultViewColumnDTO.setResultKey(searchResultViewColumn.getResultKey());
        searchResultViewColumnDTO.setSearchConfigTableAlias(searchResultViewColumn.getSearchConfigurationTable().getAlias());
        searchResultViewColumnDTO.setSortable(searchResultViewColumn.getSortable());
        SearchAggregationColumn searchAggregationColumn = searchResultViewColumn.getSearchAggregationColumn();
        if (searchAggregationColumn != null) {
            SearchAggregateColumnDTO searchAggregateColumnDTO = this.converSearchAggregateColumnEntityToDTO(searchAggregationColumn);
            searchResultViewColumnDTO.setSearchAggregateColumn(searchAggregateColumnDTO);
        }
        if ((searchResultFormatterParams = searchResultViewColumn.getSearchResultFormatterParams()) != null) {
            SearchResultFormatterParamsDTO searchResultFormatterParamsDTO = this.convertSearchResultFormatterParamsEntityToDTO(searchResultFormatterParams);
            searchResultViewColumnDTO.setSearchResultFormatterParams(searchResultFormatterParamsDTO);
        }
        if ((searchSQLGroup = searchResultViewColumn.getSearchSQLGroup()) != null) {
            searchResultViewColumnDTO.setSearchSQLGroupName(searchSQLGroup.getGroupName());
        }
        searchResultViewColumnDTO.setSearchTableColumnName(searchResultViewColumn.getSearchTableColumn().getColumnName());
        searchResultViewColumnDTO.setSqlFunction(searchResultViewColumn.getSqlFunction());
        searchResultViewColumnDTO.setVisibility(searchResultViewColumn.getVisibility());
        searchResultViewColumnDTO.setWhetherHyperlink(searchResultViewColumn.getWhetherHyperlink());
        return searchResultViewColumnDTO;
    }

    private SearchResultFormatterParamsDTO convertSearchResultFormatterParamsEntityToDTO(SearchResultFormatterParams searchResultFormatterParams) {
        SearchResultFormatterParamsDTO searchResultFormatterParamsDTO = new SearchResultFormatterParamsDTO();
        searchResultFormatterParamsDTO.setFormatterParamskey(searchResultFormatterParams.getParam());
        searchResultFormatterParamsDTO.setResultColumnResultKey(searchResultFormatterParams.getKey());
        searchResultFormatterParamsDTO.setWhetherResultColumn(searchResultFormatterParams.getWhetherResultColumn());
        searchResultFormatterParamsDTO.setId(searchResultFormatterParams.getId());
        return searchResultFormatterParamsDTO;
    }

    private SearchAggregateColumnDTO converSearchAggregateColumnEntityToDTO(SearchAggregationColumn searchAggregationColumn) {
        SearchAggregateColumnDTO searchAggregateColumnDTO = new SearchAggregateColumnDTO();
        searchAggregateColumnDTO.setId(searchAggregationColumn.getId());
        searchAggregateColumnDTO.setAggregateFunction(searchAggregationColumn.getAggregateFunction());
        searchAggregateColumnDTO.setAliasName(searchAggregationColumn.getAliasName());
        searchAggregateColumnDTO.setSearchTableColumnId(searchAggregationColumn.getSearchTableColumn().getColumnName());
        searchAggregateColumnDTO.setSearchTableId(searchAggregationColumn.getSearchTable().getDbTableName());
        return searchAggregateColumnDTO;
    }
}

