/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.LinkedList;
import net.jcip.annotations.Immutable;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.optimize.AddAccessNodes;
import org.modeshape.graph.query.optimize.ChooseJoinAlgorithm;
import org.modeshape.graph.query.optimize.CopyCriteria;
import org.modeshape.graph.query.optimize.Optimizer;
import org.modeshape.graph.query.optimize.OptimizerRule;
import org.modeshape.graph.query.optimize.PushProjects;
import org.modeshape.graph.query.optimize.PushSelectCriteria;
import org.modeshape.graph.query.optimize.RaiseVariableName;
import org.modeshape.graph.query.optimize.ReplaceViews;
import org.modeshape.graph.query.optimize.RewriteAsRangeCriteria;
import org.modeshape.graph.query.optimize.RewriteIdentityJoins;
import org.modeshape.graph.query.optimize.RightOuterToLeftOuterJoins;
import org.modeshape.graph.query.plan.PlanHints;
import org.modeshape.graph.query.plan.PlanNode;

@Immutable
public class RuleBasedOptimizer
implements Optimizer {
    private static final Logger LOGGER = Logger.getLogger(RuleBasedOptimizer.class);

    @Override
    public PlanNode optimize(QueryContext context, PlanNode plan) {
        LinkedList<OptimizerRule> rules = new LinkedList<OptimizerRule>();
        this.populateRuleStack(rules, context.getHints());
        Problems problems = context.getProblems();
        while (rules.peek() != null && !problems.hasErrors()) {
            OptimizerRule nextRule = rules.poll();
            LOGGER.debug("Running query optimizer rule {0}", nextRule);
            plan = nextRule.execute(context, plan, rules);
        }
        return plan;
    }

    protected void populateRuleStack(LinkedList<OptimizerRule> ruleStack, PlanHints hints) {
        if (hints.hasSubqueries) {
            ruleStack.addFirst(RaiseVariableName.INSTANCE);
        }
        ruleStack.addFirst(RewriteAsRangeCriteria.INSTANCE);
        if (hints.hasJoin) {
            ruleStack.addFirst(ChooseJoinAlgorithm.USE_ONLY_NESTED_JOIN_ALGORITHM);
            ruleStack.addFirst(RewriteIdentityJoins.INSTANCE);
        }
        ruleStack.addFirst(PushProjects.INSTANCE);
        ruleStack.addFirst(PushSelectCriteria.INSTANCE);
        ruleStack.addFirst(AddAccessNodes.INSTANCE);
        ruleStack.addFirst(RightOuterToLeftOuterJoins.INSTANCE);
        ruleStack.addFirst(CopyCriteria.INSTANCE);
        if (hints.hasView) {
            ruleStack.addFirst(ReplaceViews.INSTANCE);
        }
    }
}

