/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request.processor;

import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CompositeRequest;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.DeleteChildrenRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.LockBranchRequest;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.ReadBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadBranchRequest;
import org.modeshape.graph.request.ReadNextBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.ReadPropertyRequest;
import org.modeshape.graph.request.RemovePropertyRequest;
import org.modeshape.graph.request.RenameNodeRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.SetPropertyRequest;
import org.modeshape.graph.request.UnlockBranchRequest;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.UpdateValuesRequest;
import org.modeshape.graph.request.VerifyNodeExistsRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;
import org.modeshape.graph.request.processor.RequestProcessor;

@Immutable
public class LoggingRequestProcessor
extends RequestProcessor {
    private final RequestProcessor delegate;
    private static final Logger LOGGER = Logger.getLogger(LoggingRequestProcessor.class);
    private final Logger.Level level;

    public LoggingRequestProcessor(RequestProcessor delegate, Logger logger2, Logger.Level level) {
        super(delegate.getSourceName(), delegate.getExecutionContext(), null);
        CheckArg.isNotNull(logger2, "logger");
        this.delegate = delegate;
        this.level = level != null ? level : Logger.Level.TRACE;
    }

    @Override
    public void process(VerifyWorkspaceRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
    }

    @Override
    public void process(GetWorkspacesRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(CreateWorkspaceRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(CloneBranchRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(CloneWorkspaceRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(DestroyWorkspaceRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(CopyBranchRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(CreateNodeRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(DeleteBranchRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(DeleteChildrenRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(MoveBranchRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(VerifyNodeExistsRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(ReadAllChildrenRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(ReadAllPropertiesRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(UpdatePropertiesRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(UpdateValuesRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(CompositeRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(ReadBlockOfChildrenRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(ReadNextBlockOfChildrenRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(ReadBranchRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(ReadNodeRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(ReadPropertyRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(SetPropertyRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(RemovePropertyRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(RenameNodeRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(LockBranchRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(UnlockBranchRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(AccessQueryRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(FullTextSearchRequest request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void process(Request request) {
        LOGGER.log(this.level, GraphI18n.executingRequest, request);
        this.delegate.process(request);
        LOGGER.log(this.level, GraphI18n.executedRequest, request);
    }

    @Override
    public void close() {
        LOGGER.log(this.level, GraphI18n.closingRequestProcessor, new Object[0]);
        this.delegate.close();
        LOGGER.log(this.level, GraphI18n.closedRequestProcessor, new Object[0]);
    }
}

