ALTER TABLE `evaluation_program_rank_history` 
DROP COLUMN `periodName`,
CHANGE COLUMN `programBatchPeriodId` `batchId` BIGINT(20) NULL DEFAULT NULL ,
ADD COLUMN `programName` VARCHAR(255) NULL AFTER `batchId`;

CREATE TABLE `evaluation_period_rank_history` (
  `id` BIGINT(20) NOT NULL,
  `REV` INT(11) NOT NULL,
  `REVTYPE` TINYINT(4) NULL,
  `lastUpdate` DATETIME NULL,
  `evaluationPlanType` VARCHAR(255) NULL,
  `marksObtainedFrom` BIGINT(20) NULL,
  `obtainedMarks` DOUBLE NULL,
  `rank` INT(11) NULL,
  `sgpa` DOUBLE NULL,
  `stage` VARCHAR(255) NULL,
  `status` VARCHAR(255) NULL,
  `hallticket` VARCHAR(255) NULL,
  `sectionName` VARCHAR(255) NULL,
  `batchName` VARCHAR(255) NULL,
  `programName` VARCHAR(255) NULL,
  `periodName` VARCHAR(255) NULL,
  `admissionId` BIGINT(20) NULL,
  PRIMARY KEY (`id`, `REV`));
  
ALTER TABLE `evaluation_period_rank_history` 
ADD COLUMN `lastUpdatedBy` BIGINT(20) NULL AFTER `admissionId`;

ALTER TABLE `evaluation_period_rank_history` 
ADD COLUMN `periodId` BIGINT(20) NULL AFTER `lastUpdatedBy`;

ALTER TABLE `evaluation_period_rank_history` 
ADD COLUMN `creditSum` BIGINT(10) NULL AFTER `periodId`,
ADD COLUMN `creditGradePointSum` DOUBLE NULL AFTER `creditSum`;

ALTER TABLE `marksheet_history` 
CHANGE COLUMN `REV` `REV` INT(11) NOT NULL ,
DROP PRIMARY KEY,
ADD PRIMARY KEY (`id`, `REV`);

ALTER TABLE `evaluation_program_rank_history` 
ADD COLUMN `creditSum` BIGINT NULL AFTER `programName`,
ADD COLUMN `creditGradePointSum` DOUBLE NULL AFTER `creditSum`;