CREATE TABLE `placement_job_application_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `applicationStatus` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `joiningStatus` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `offerStatus` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `recruitmentOrganizationId` bigint(20) DEFAULT NULL,
  `jobId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `placement_job_application_joining_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `joiningDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `jobApplicationId` bigint(20) DEFAULT NULL,
  `confirmedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `placement_job_application_location_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `jobApplicationId` bigint(20) DEFAULT NULL,
  `joblocationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `placement_job_application_offer_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `dateOfJoining` date DEFAULT NULL,
  `salaryPackage` double DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `jobApplicationId` bigint(20) DEFAULT NULL,
  `joblocationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `placement_job_application_resume_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `jobApplicationId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `placement_job_application_stage_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `currentStatus` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rank` bigint(20) DEFAULT NULL,
  `stageMarks` float DEFAULT NULL,
  `totalMarks` float DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `jobApplicationId` bigint(20) DEFAULT NULL,
  `placementSelectionStageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `placement_job_application_stage_marks_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `marksObtained` float DEFAULT NULL,
  `obtainedGrade` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `jobApplicationStageId` bigint(20) DEFAULT NULL,
  `evaluationParameterWeightageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `placement_selection_stage_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `currentStatus` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `entryRule` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entryRuleDescription` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `exitRule` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `exitRuleDescription` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `maxSeat` int(11) DEFAULT NULL,
  `minSeat` int(11) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `whetherFinalStage` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `jobId` bigint(20) DEFAULT NULL,
  `selectionProcessStageId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
