DELIMITER $$
DROP PROCEDURE IF EXISTS V20201224161431__Alter_ElectionVoterPoolAddColHistory $$
CREATE PROCEDURE V20201224161431__Alter_ElectionVoterPoolAddColHistory()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='election_voter_pool_history' AND column_name in ('admissionId','batchId','seatTypeId','programId'))) THEN 
ALTER TABLE `election_voter_pool_history` 
ADD COLUMN `admissionId` BIGINT NULL DEFAULT NULL AFTER `lastUpdate`,
ADD COLUMN `batchId` BIGINT NULL DEFAULT NULL AFTER `admissionId`,
ADD COLUMN `programId` BIGINT NULL DEFAULT NULL AFTER `batchId`,
ADD COLUMN `seatTypeId` BIGINT NULL DEFAULT NULL AFTER `programId`,
ADD INDEX `fk_ev_pool_admisionId_idx` (`admissionId` ASC) VISIBLE,
ADD INDEX `fk_ev_pool_programId_idx` (`programId` ASC) VISIBLE,
ADD INDEX `fk_ev_pool_seat_type_id_idx` (`seatTypeId` ASC) VISIBLE,
ADD INDEX `fk_ev_pool_programbatchId_idx` (`batchId` ASC) VISIBLE;
END IF; 

END $$
CALL V20201224161431__Alter_ElectionVoterPoolAddColHistory() $$
DROP PROCEDURE IF EXISTS V20201224161431__Alter_ElectionVoterPoolAddColHistory $$
DELIMITER ;