DELIMITER $$
DROP PROCEDURE IF EXISTS V20230726134712__Create_Student_Health_DropDown_Audit $$
CREATE PROCEDURE V20230726134712__Create_Student_Health_DropDown_Audit()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_health_medical_condition_history')) THEN 
CREATE TABLE `student_health_medical_condition_history` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
	`REV` bigint(20) NOT NULL,
    `REVTYPE` tinyint(4) DEFAULT NULL,
	`healthId` BIGINT(20) NOT NULL,
	`medicalConditionId` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`,`REV`)	
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_health_medication_history')) THEN
CREATE TABLE `student_health_medication_history` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`REV` bigint(20) NOT NULL,
    `REVTYPE` tinyint(4) DEFAULT NULL,	
	`healthId` BIGINT(20) NOT NULL,
	`medicationId` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_health_allergies_history')) THEN
CREATE TABLE `student_health_allergies_history` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`REV` bigint(20) NOT NULL,
    `REVTYPE` tinyint(4) DEFAULT NULL,	
	`healthId` BIGINT(20) NOT NULL,
	`allergieId` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`,`REV`)
	
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_health_learning_difficulties_history')) THEN
CREATE TABLE `student_health_learning_difficulties_history` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`REV` bigint(20) NOT NULL,
    `REVTYPE` tinyint(4) DEFAULT NULL,	
	`healthId` BIGINT(20) NOT NULL,
	`learningDifficultieId` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230726134712__Create_Student_Health_DropDown_Audit () $$ 
DROP PROCEDURE IF EXISTS V20230726134712__Create_Student_Health_DropDown_Audit $$ 
DELIMITER ;