SET FOREIGN_KEY_CHECKS=0;
DROP TABLE IF exists `external_course_master`;
CREATE TABLE `external_course_master` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `externalCourseCode` varchar(45) DEFAULT NULL,
  `externalCourseName` varchar(255) DEFAULT NULL,
  `externalOrganizationName` varchar(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refusers4563_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refusers4563` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF exists `evaluation_plan_other_category`;
CREATE TABLE `evaluation_plan_other_category` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `categoryName` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refusers6575_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refusers6575` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF exists `evaluation_plan`;
CREATE TABLE `evaluation_plan` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `evaluationPlanType` varchar(45) NOT NULL,
  `evaluationStage` varchar(45) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `evaluationPlanNumber` varchar(255) NOT NULL,
  `externalCourseId` bigint(20) DEFAULT NULL,
  `externalOrganizationName` varchar(50) DEFAULT NULL,
  `categoryId` bigint(20) DEFAULT NULL,
  `whetherInheritplan` bit(1) DEFAULT NULL,
  `inheritFromEvaluationPlan` bigint(20) DEFAULT NULL,
  `isWeightagesRelevant` bit(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refcourses678` (`courseId`),
  KEY `Refusers1277` (`lastUpdatedBy`),
  KEY `Refexternalcourse123_idx` (`externalCourseId`),
  KEY `Refcategory343_idx` (`categoryId`),
  KEY `Refinheriteplan435_idx` (`inheritFromEvaluationPlan`),
  CONSTRAINT `Refcategory343` FOREIGN KEY (`categoryId`) REFERENCES `evaluation_plan_other_category` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refcourses678` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`),
  CONSTRAINT `Refexternalcourse123` FOREIGN KEY (`externalCourseId`) REFERENCES `external_course_master` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refinheriteplan435` FOREIGN KEY (`inheritFromEvaluationPlan`) REFERENCES `evaluation_plan` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refusers1277` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF exists `evaluation_type_program`;
CREATE TABLE `evaluation_type_program` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `programBatchPeriodConfigId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  `completionStatus` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Refevaluation_plan648` (`evaluationPlanId`),
  KEY `Refprog_batch_period_config790` (`programBatchPeriodConfigId`),
  KEY `Refsections1156` (`sectionId`),
  KEY `Refusers1468` (`lastUpdatedBy`),
  CONSTRAINT `Refevaluation_plan648` FOREIGN KEY (`evaluationPlanId`) REFERENCES `evaluation_plan` (`id`),
  CONSTRAINT `Refprog_batch_period_config790` FOREIGN KEY (`programBatchPeriodConfigId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `Refsections1156` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`),
  CONSTRAINT `Refusers1468` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF exists `evaluation_type_course`;
CREATE TABLE `evaluation_type_course` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `completionStatus` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Refevaluation_plan786` (`evaluationPlanId`),
  KEY `Refusers1467` (`lastUpdatedBy`),
  CONSTRAINT `Refevaluation_plan786` FOREIGN KEY (`evaluationPlanId`) REFERENCES `evaluation_plan` (`id`),
  CONSTRAINT `Refusers1467` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF exists `evaluation_plan_level_one`;
CREATE TABLE `evaluation_plan_level_one` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `evaluationPlanId` bigint(20) DEFAULT NULL,
  `levelName` varchar(100) DEFAULT NULL,
  `levelValue` varchar(30) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refevaluation_plan1152` (`evaluationPlanId`),
  KEY `Refusers1279` (`lastUpdatedBy`),
  CONSTRAINT `Refevaluation_plan1152` FOREIGN KEY (`evaluationPlanId`) REFERENCES `evaluation_plan` (`id`),
  CONSTRAINT `Refusers1279` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF exists `external_course_assessment`;
CREATE TABLE `external_course_assessment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `externalCourseId` bigint(20) DEFAULT NULL,
  `assessmentType` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Refexternalcourse434_idx` (`externalCourseId`),
  KEY `Refusers7865_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refexternalcourse434` FOREIGN KEY (`externalCourseId`) REFERENCES `external_course_master` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refusers7865` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF exists `evaluation_plan_other_sub_category`;
CREATE TABLE `evaluation_plan_other_sub_category` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `categoryId` bigint(20) NOT NULL,
  `subCategoryName` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refcategory353_idx` (`categoryId`),
  KEY `Refusers4242_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refcategory353` FOREIGN KEY (`categoryId`) REFERENCES `evaluation_plan_other_category` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refusers4242` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF exists `evaluation_plan_level_two`;
CREATE TABLE `evaluation_plan_level_two` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `evalPlanLevelOneId` bigint(20) DEFAULT NULL,
  `levelName` varchar(100) DEFAULT NULL,
  `levelValue` varchar(30) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refevaluation_plan_level_one1153` (`evalPlanLevelOneId`),
  KEY `Refusers1280` (`lastUpdatedBy`),
  CONSTRAINT `Refevaluation_plan_level_one1153` FOREIGN KEY (`evalPlanLevelOneId`) REFERENCES `evaluation_plan_level_one` (`id`),
  CONSTRAINT `Refusers1280` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF exists `evaluation_sequence`;
CREATE TABLE `evaluation_sequence` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `evalPlanLevelTwoId` bigint(20) NOT NULL,
  `evalSequenceId` bigint(20) NOT NULL,
  `regularDroolsRule` varchar(255) DEFAULT NULL,
  `regularDroolsRuleDesc` varchar(255) DEFAULT NULL,
  `repetitionDroolsRuleDesc` varchar(255) DEFAULT NULL,
  `evalSequenceWeightage` int(11) DEFAULT NULL,
  `whetherStaffLogistics` bit(1) DEFAULT NULL,
  `whetherQPApplicable` bit(1) DEFAULT NULL,
  `whetherExamCenterLogistics` bit(1) DEFAULT NULL,
  `whetherAttendanceRelevant` bit(1) DEFAULT NULL,
  `numberOfAssessments` int(11) DEFAULT NULL,
  `numberOfAssessmentsCompleted` int(11) DEFAULT NULL,
  `numberOfAssessmentsClosed` int(11) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refusers1285` (`lastUpdatedBy`),
  KEY `Refevaluation_plan_level_two1155` (`evalPlanLevelTwoId`),
  KEY `Refevaluationsequence868_idx` (`evalSequenceId`),
  CONSTRAINT `Refevaluationsequence868` FOREIGN KEY (`evalSequenceId`) REFERENCES `sequence_header` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refevaluation_plan_level_two1155` FOREIGN KEY (`evalPlanLevelTwoId`) REFERENCES `evaluation_plan_level_two` (`id`),
  CONSTRAINT `Refusers1285` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF exists `eval_seq_detail`;
CREATE TABLE `eval_seq_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `evalSequenceId` bigint(20) DEFAULT NULL,
  `detailSequenceNumber` varchar(45) DEFAULT NULL,
  `detailSequenceDesc` varchar(255) DEFAULT NULL,
  `whetherPrimaryDetailSequence` bit(1) NOT NULL,
  `secondaryDetailSequenceId` bigint(20) DEFAULT NULL,
  `whetherWrittenTest` bit(1) NOT NULL,
  `whetherSurpriseTest` bit(1) NOT NULL,
  `plannedDate` date NOT NULL,
  `plannedOn` datetime DEFAULT NULL,
  `plannedTill` datetime DEFAULT NULL,
  `mandatoryForEvaluation` bit(1) NOT NULL,
  `mandatoryForAttendance` bit(1) NOT NULL,
  `noOfQPRequired` int(11) DEFAULT NULL,
  `modeOfAdministration` varchar(45) DEFAULT NULL,
  `whetherObjectTypeQuestions` bit(1) NOT NULL,
  `randomSelectionApplicable` bit(1) DEFAULT NULL,
  `whetherBatches` bit(1) NOT NULL,
  `whetherLimitedSetOfStudent` bit(1) DEFAULT NULL,
  `whetherDetailSeqEquivalent` bit(1) NOT NULL,
  `evalDetailSeqEquivalentId` bigint(20) NOT NULL,
  `whetherAnsAvailableForReview` bit(1) NOT NULL,
  `whetherEvalAnonymous` bit(1) NOT NULL,
  `revaluationType` varchar(45) DEFAULT NULL,
  `notificationType` varchar(45) DEFAULT NULL,
  `notificationNoOfDays` int(11) NOT NULL,
  `weightage` varchar(10) DEFAULT NULL,
  `evalInMarksOrGrade` varchar(45) DEFAULT NULL,
  `gradeType` varchar(45) DEFAULT NULL,
  `maxMarksOrGrade` varchar(3) DEFAULT NULL,
  `minMarksOrGrade` varchar(3) DEFAULT NULL,
  `whetherResultApproved` bit(1) NOT NULL,
  `approvedBy` bigint(20) DEFAULT NULL,
  `timeInMinutes` int(11) DEFAULT NULL,
  `starttime` datetime DEFAULT NULL,
  `whetherExceptionToTime` bit(1) NOT NULL,
  `exceptionRuleAgenda` varchar(255) DEFAULT NULL,
  `exceptionRuleAgendaDescription` varchar(255) DEFAULT NULL,
  `marksForSequence` int(11) DEFAULT NULL,
  `partOfEvaluationGroup` bit(1) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `feeBillingDate` date DEFAULT NULL,
  `status` varchar(45) DEFAULT NULL,
  `feedbackQuestionnaire` varchar(45) DEFAULT NULL,
  `testAdministrationMode` varchar(100) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refevaluation_sequence463` (`evalSequenceId`),
  KEY `Refusers1274` (`lastUpdatedBy`),
  KEY `Reffeeplan786_idx` (`feePlanId`),
  KEY `Refsecondarydetailsequence_idx` (`secondaryDetailSequenceId`),
  KEY `Refevaldetailseqequivalent231_idx` (`evalDetailSeqEquivalentId`),
  CONSTRAINT `Refevaldetailseqequivalent231` FOREIGN KEY (`evalDetailSeqEquivalentId`) REFERENCES `eval_seq_detail` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refevaluation_sequence463` FOREIGN KEY (`evalSequenceId`) REFERENCES `evaluation_sequence` (`id`),
  CONSTRAINT `Reffeeplan786` FOREIGN KEY (`feePlanId`) REFERENCES `fee_plan` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refsecondarydetailsequence` FOREIGN KEY (`secondaryDetailSequenceId`) REFERENCES `eval_seq_detail` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refusers1274` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

SET FOREIGN_KEY_CHECKS=1;

