CREATE TABLE `student_program_attendance` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `programId` bigint(20) NOT NULL,
  `batchId` bigint(20) NOT NULL,
  `periodId` bigint(20) NOT NULL,
  `sectionId` bigint(20) NOT NULL,
  `dateOfAttendance` date NOT NULL,
  `attendanceType` varchar(20) NOT NULL,
  `fromTime` time DEFAULT NULL,
  `toTime` time DEFAULT NULL,
  `facultyId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refprograms202` (`programId`),
  KEY `Refbatches203` (`batchId`),
  KEY `Refsections510` (`sectionId`),
  KEY `Refusers1465` (`lastUpdatedBy`),
  KEY `Ref_period_idx` (`periodId`),
  KEY `Ref_faculty_idx` (`facultyId`)
);
ALTER TABLE `student_program_attendance`
  ADD CONSTRAINT `Refusers1465_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  ADD CONSTRAINT `Ref_batch_2` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `Ref_faculty_2` FOREIGN KEY (`facultyId`) REFERENCES `faculties` (`personId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `Ref_period_2` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `Ref_program_2` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `Ref_sections_2` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
;


CREATE TABLE `student_course_attendance` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `courseId` bigint(20) NOT NULL,
  `sectionId` bigint(20) NOT NULL,
  `variantId` bigint(20) NOT NULL,
  `dateOfAttendance` date NOT NULL,
  `fromTime` time DEFAULT NULL,
  `toTime` time DEFAULT NULL,
  `facultyId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refsections510` (`sectionId`),
  KEY `Refusers1465` (`lastUpdatedBy`),
  KEY `Ref_faculty_idx` (`facultyId`),
  KEY `Ref_course_idx` (`courseId`),
  KEY `Ref_variants_idx` (`variantId`),
  CONSTRAINT `Refusers1465_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `Ref_course` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Ref_faculty_1` FOREIGN KEY (`facultyId`) REFERENCES `faculties` (`personId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Ref_sections_1` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Ref_variants` FOREIGN KEY (`variantId`) REFERENCES `course_variants` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
);

CREATE TABLE `student_course_attendance_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `attendanceId` bigint(20) NOT NULL,
  `admissionId` bigint(20) NOT NULL,
  `attendanceStatus` varchar(25) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refusers1464_3` (`lastUpdatedBy`),
  KEY `Refstudent_course_attendance1837_3` (`attendanceId`),
  KEY `Ref_admission_idx_3` (`admissionId`),
  CONSTRAINT `Refstudent_course_attendance1837_3` FOREIGN KEY (`attendanceId`) REFERENCES `student_course_attendance` (`id`),
  CONSTRAINT `Refusers1464_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `Ref_admission_3` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
);

CREATE TABLE `student_program_attendance_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `attendanceId` bigint(20) NOT NULL,
  `admissionId` bigint(20) NOT NULL,
  `attendanceStatus` varchar(25) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refusers1464_4` (`lastUpdatedBy`),
  KEY `Refstudent_program_attendance1837_4` (`attendanceId`),
  KEY `Ref_admission_idx_4` (`admissionId`),
  CONSTRAINT `Refstudent_program_attendance1837_4` FOREIGN KEY (`attendanceId`) REFERENCES `student_program_attendance` (`id`),
  CONSTRAINT `Refusers1464_4` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `Ref_admission_4` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
);

