CREATE TABLE `marksheet_jasper_report_master` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `jasperCode` VARCHAR(150) NULL DEFAULT NULL,
  `imagePath` VARCHAR(225) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`));

set foreign_key_checks=0;

ALTER TABLE `marksheet_template_type` 
CHANGE COLUMN `id` `id` BIGINT(20) NOT NULL ,
CHANGE COLUMN `type` `templateName` VARCHAR(75) NULL DEFAULT NULL ,
ADD COLUMN `academyLocationId` BIGINT(20) NULL DEFAULT NULL AFTER `templateName`,
ADD COLUMN `marksheetJasperReportMasterId` BIGINT(20) NULL DEFAULT NULL AFTER `academyLocationId`,
ADD INDEX `fk_marksheet_template_type_3_idx` (`marksheetJasperReportMasterId` ASC),
ADD INDEX `fk_marksheet_template_type_2_idx` (`academyLocationId` ASC),
CHANGE COLUMN `lastUpdatedBy` `lastUpdatedBy` BIGINT(20) NOT NULL AFTER `marksheetJasperReportMasterId`;


ALTER TABLE `marksheet_template_type` 
ADD CONSTRAINT `fk_marksheet_template_type_2`
  FOREIGN KEY (`academyLocationId`)
  REFERENCES `academy_location` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_marksheet_template_type_3`
  FOREIGN KEY (`marksheetJasperReportMasterId`)
  REFERENCES `marksheet_jasper_report_master` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  
set foreign_key_checks=1;  
  
