CREATE TABLE `column_mappings` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `customFieldDataType` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `columnName` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `customType` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
);


CREATE TABLE `custom_table_configs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `displayName` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `tableName` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `customTableName` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
);

CREATE TABLE `standard_master_category` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tableName` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `displayName` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customQuery` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
);

CREATE TABLE `custom_field_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `whetherCustomField` bit(1) DEFAULT NULL,
  `customFieldDataType` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customTableConfigId` bigint(20) DEFAULT NULL,
  `columnMappingId` bigint(20) DEFAULT NULL,
  `displayName` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `whetherMandatory` bit(1) DEFAULT NULL,
  `displayOrder` int(11) DEFAULT NULL,
  `droolName` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `whetherStandardMaster` bit(1) DEFAULT NULL,
  `standardMasterCategoryId` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customTableConfigId` (`customTableConfigId`),
  KEY `columnMappingId` (`columnMappingId`),
  KEY `standardMasterCategoryId` (`standardMasterCategoryId`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `custom_field_config_ibfk_1` FOREIGN KEY (`customTableConfigId`) REFERENCES `custom_table_configs` (`id`),
  CONSTRAINT `custom_field_config_ibfk_2` FOREIGN KEY (`columnMappingId`) REFERENCES `column_mappings` (`id`),
  CONSTRAINT `custom_field_config_ibfk_4` FOREIGN KEY (`standardMasterCategoryId`) REFERENCES `standard_master_category` (`id`),
  CONSTRAINT `custom_field_config_ibfk_5` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);

CREATE TABLE `categories_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `customFieldConfigId` bigint(20) DEFAULT NULL,
  `displayOrder` int(11) DEFAULT NULL,
  `whetherDeleted` bit(1) DEFAULT NULL,
  `subCategoryName` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `version` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customFieldConfigId` (`customFieldConfigId`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `categories_info_ibfk_1` FOREIGN KEY (`customFieldConfigId`) REFERENCES `custom_field_config` (`id`),
  CONSTRAINT `categories_info_ibfk_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);


insert  into `column_mappings`(`id`,`customFieldDataType`,`columnName`,`customType`) values (1,'TEXTFIELD','cf1','CUSTOM_FIELD'),(2,'TEXTFIELD','cf2','CUSTOM_FIELD'),(3,'TEXTFIELD','cf3','CUSTOM_FIELD'),(4,'TEXTFIELD','cf4','CUSTOM_FIELD'),(5,'TEXTFIELD','cf5','CUSTOM_FIELD'),(6,'TEXTFIELD','cf6','CUSTOM_FIELD'),(7,'TEXTFIELD','cf7','CUSTOM_FIELD'),(8,'TEXTFIELD','cf8','CUSTOM_FIELD'),(9,'TEXTFIELD','cf9','CUSTOM_FIELD'),(10,'TEXTFIELD','cf10','CUSTOM_FIELD'),(11,'COMBOBOX','cf11','CUSTOM_CATEGORY'),(12,'COMBOBOX','cf12','CUSTOM_CATEGORY'),(13,'COMBOBOX','cf13','CUSTOM_CATEGORY'),(14,'DATEFIELD','cf14','CUSTOM_FIELD'),(15,'DATEFIELD','cf15','CUSTOM_FIELD'),(16,'CHECKBOX','cf16','CUSTOM_FIELD'),(17,'CHECKBOX','cf17','CUSTOM_FIELD'),(18,'TEXTAREA','cf18','CUSTOM_FIELD'),(19,'TEXTAREA','cf19','CUSTOM_FIELD');

insert  into `standard_master_category`(`id`,`tableName`,`displayName`,`customQuery`) values (1,'city','City','SELECT id AS id,cityName AS VALUE FROM city;'),(2,'country','Country','SELECT id AS id,countryName AS VALUE FROM country;');

insert  into `custom_table_configs`(`id`,`displayName`,`tableName`,`customTableName`) values (1,'Academy','academies','academies_cd');

CREATE TABLE `academies_cd` (
  `id` bigint(255) NOT NULL AUTO_INCREMENT,
  `cf1` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf2` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf3` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf4` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf5` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf6` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf7` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf8` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf9` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf10` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `academyId` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `cf11` bigint(20) DEFAULT NULL,
  `cf12` bigint(20) DEFAULT NULL,
  `cf13` bigint(20) DEFAULT NULL,
  `cf14` timestamp NULL DEFAULT NULL,
  `cf15` timestamp NULL DEFAULT NULL,
  `cf16` bit(1) DEFAULT NULL,
  `cf17` bit(1) DEFAULT NULL,
  `cf18` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf19` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `academyId` (`academyId`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `academies_cd_ibfk_1` FOREIGN KEY (`academyId`) REFERENCES `academies` (`id`),
  CONSTRAINT `academies_cd_ibfk_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);