CREATE TABLE `trans_route_location_academy_location` (
    `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
    `routeLocationId` BIGINT(20) NOT NULL,
    `academyLocationId` BIGINT(20) NOT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
    `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    INDEX `fk_trans_route_location_academy_location_1_idx` (`academyLocationId` ASC),
    INDEX `fk_trans_route_location_academy_location_2_idx` (`routeLocationId` ASC),
    CONSTRAINT `fk_trans_route_location_academy_location_1` FOREIGN KEY (`academyLocationId`)
        REFERENCES `academy_location` (`id`)
        ON DELETE RESTRICT ON UPDATE RESTRICT,
    CONSTRAINT `fk_trans_route_location_academy_location_2` FOREIGN KEY (`routeLocationId`)
        REFERENCES `trans_route_location` (`id`)
        ON DELETE RESTRICT ON UPDATE RESTRICT
)  ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `trans_service_route_academy_location` (
    `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
    `transServiceRouteId` BIGINT(20) NOT NULL,
    `academyLocationId` BIGINT(20) NOT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
    `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    INDEX `fk_trans_service_route_academy_location_1_idx` (`academyLocationId` ASC),
    INDEX `fk_trans_service_route_academy_location_2_idx` (`transServiceRouteId` ASC),
    CONSTRAINT `fk_trans_service_route_academy_location_1_idx` FOREIGN KEY (`academyLocationId`)
        REFERENCES `academy_location` (`id`)
        ON DELETE RESTRICT ON UPDATE RESTRICT,
    CONSTRAINT `fk_trans_service_route_academy_location_2_idx` FOREIGN KEY (`transServiceRouteId`)
        REFERENCES `trans_service_route` (`id`)
        ON DELETE RESTRICT ON UPDATE RESTRICT
)  ENGINE=InnoDB DEFAULT CHARSET=utf8;


INSERT INTO standard_master(`tableName`, `masterName`,`moduleName`, `whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
 VALUES ('trans_route_location_academy_location', 'TRANS_ROUTE_LOCATION_ACADEMY_LOCATION', 'Transport', 1, 0, '1', SYSDATE());

SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES ('academyLocation', 'ACADEMY_LOCATION', @standardMasterMaxId, 'Varchar', '1', 1, 'academy_location', 'id','academyLocationName', 0, 0, 1, '1', SYSDATE());

SET @standardMasterRouteLocationId=(SELECT id FROM standard_master where standard_master.tableName='trans_route_location');
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
update standard_master set `childMaster`= @standardMasterMaxId, `whetherParent`=1 where `id`= @standardMasterRouteLocationId;
