
SET @OLD_SQL_SAFE_UPDATES = @@SQL_SAFE_UPDATES;
SET SQL_SAFE_UPDATES =0;

-- add column in applicant_person
ALTER TABLE `applicant_person`   
  ADD COLUMN `mobileCountryCode` VARCHAR(10) NULL AFTER `mobileNumber`,
  ADD COLUMN `phoneNo` VARCHAR(15) NULL AFTER `mobileCountryCode`,
  ADD COLUMN `phoneCountryCode` VARCHAR(10) NULL AFTER `phoneNo`,
  ADD COLUMN `phoneAreaCode` VARCHAR(11) NULL AFTER `phoneCountryCode`;
  
  
  -- update data in from application table in applicant_person
UPDATE `applicant_person` ap SET mobileNumber =(SELECT cellNo FROM `application` tp WHERE tp.applicantPersonId = ap.id LIMIT 1) WHERE ap.mobileNumber IS NULL;
UPDATE `applicant_person` ap SET phoneNo =(SELECT phoneNo FROM `application` tp WHERE tp.applicantPersonId = ap.id LIMIT 1);
UPDATE `applicant_person` ap SET emailId =(SELECT primaryEmailId FROM `application` tp WHERE tp.applicantPersonId = ap.id LIMIT 1);
UPDATE `applicant_person` ap SET phoneAreaCode =(SELECT phoneAreaCode FROM `application` tp WHERE tp.applicantPersonId = ap.id LIMIT 1);

-- =============================================================================================================
--  ================ query for data of student  ================ 
-- create temp table to store data of student, person id and contact details

	CREATE TABLE temp_admission 
	(
	 mobileNo BIGINT,
	 emailId VARCHAR(50),
	 phoneNo VARCHAR(50),
	 phoneAreaCode VARCHAR(50), 
	 studentId BIGINT, 
	 personId BIGINT);


-- add data to temp table
INSERT INTO temp_admission ( mobileNo, phoneNo,  emailId, phoneAreaCode, studentId, personId)
SELECT DISTINCT appl.cellNo, appl.phoneNo, appl.primaryEmailId, appl.phoneAreaCode , 
 a.studentId, s.personId
FROM admission a
LEFT JOIN students s ON a.studentId = s.userId
INNER JOIN application_program ap ON ap.id =a.applicationProgramId
INNER JOIN application  appl ON ap.applicationId = appl.id
 ORDER BY cellNo DESC;
 
-- add column in persons table
ALTER TABLE `persons`   
  ADD COLUMN `mobileCountryCode` VARCHAR(10) NULL AFTER `mobileNumber`,
  ADD COLUMN `phoneNo` VARCHAR(15) NULL AFTER `mobileCountryCode`,
  ADD COLUMN `phoneCountryCode` VARCHAR(10) NULL AFTER `phoneNo`,
  ADD COLUMN `phoneAreaCode` VARCHAR(11) NULL AFTER `phoneCountryCode`;
  
-- update data in from temp_admission table in persons

UPDATE `persons` SET mobileNumber =(SELECT mobileNo FROM `temp_admission` tp WHERE tp.personId = id LIMIT 1) WHERE mobileNumber IS NULL;
UPDATE `persons` SET emailId =(SELECT emailId FROM `temp_admission` tp WHERE tp.personId = id LIMIT 1) WHERE emailId IS NULL;
UPDATE `persons` SET phoneNo =(SELECT phoneNo FROM`temp_admission` tp WHERE tp.personId = id LIMIT 1);
UPDATE `persons` SET phoneAreaCode =(SELECT phoneAreaCode FROM`temp_admission` tp WHERE tp.personId = id LIMIT 1);

SET SQL_SAFE_UPDATES = @OLD_SQL_SAFE_UPDATES;

DROP TABLE `temp_admission`;