CREATE 
    OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `pnc_dashboard_course_summary_report_view` AS
    select 
        `T0`.`courseId` AS `courseId`,
        `courses`.`courseCode` AS `courseCode`,
        `courses`.`courseName` AS `courseName`,
        `course_variants`.`courseVariantCode` AS `courseVariantCode`,
        `T0`.`dateOfAttendance` AS `dateOfAttendance`,
        `sections`.`periodId` AS `periodId`,
        (select 
                count(0)
            from
                `student_course_attendance_details` `T1`
            where
                (`T1`.`attendanceId` = `T0`.`id`)) AS `totalStudents`,
        (select 
                count(0)
            from
                `student_course_attendance_details` `T2`
            where
                ((`T2`.`attendanceId` = `T0`.`id`)
                    and (`T2`.`attendanceStatus` in ('PRESENT' , 'present', 'Present')))) AS `totalPresent`,
        (select 
                count(0)
            from
                `student_course_attendance_details` `T2`
            where
                ((`T2`.`attendanceId` = `T0`.`id`)
                    and (`T2`.`attendanceStatus` not in ('PRESENT' , 'present', 'Present')))) AS `totalAbsent`
    from
        ((((`student_course_attendance` `T0`
        join `student_course_attendance_details` ON ((`student_course_attendance_details`.`attendanceId` = `T0`.`id`)))
        join `courses` ON ((`courses`.`id` = `T0`.`courseId`)))
        join `course_variants` ON ((`course_variants`.`id` = `T0`.`variantId`)))
        join `sections` ON ((`sections`.`id` = `T0`.`sectionId`)))
    group by `T0`.`id`