CREATE OR REPLACE VIEW `fee_dashboard_outstanding_userwise_applicant_summary` AS
    SELECT 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `applicant_person`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `application`.`id` AS `applicantId`,
        `application`.`code` AS `applicationNumber`,
        `bill_header`.`id` AS `billId`
    FROM
        (((((((((((((((((`bill_header`
        LEFT JOIN `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        LEFT JOIN `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        LEFT JOIN `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        LEFT JOIN `application` ON ((`bill_header`.`applicantId` = `application`.`id`)))
        LEFT JOIN `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
        LEFT JOIN `applicant_person` ON ((`application`.`applicantPersonId` = `applicant_person`.`id`)))
        LEFT JOIN `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        LEFT JOIN `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        LEFT JOIN `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        LEFT JOIN `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            AND (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        LEFT JOIN `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        LEFT JOIN `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        LEFT JOIN `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        LEFT JOIN `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        LEFT JOIN `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        LEFT JOIN `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        LEFT JOIN `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    WHERE
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            AND (`bill_header`.`applicantId` IS NOT NULL)
            AND (`fee_plan_type`.`feePlanType` IN ('Application' , 'Program')));
