CREATE TABLE `moodle_setup_info`( 
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
	`academyLocationId` BIGINT(20), 
	`hostURL` VARCHAR(255),
	 `isDefault` BIT(1),
	 `isActive` BIT(1),
	 `lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	 `lastUpdatedBy` BIGINT(20),
	  PRIMARY KEY (`id`), 
	  CONSTRAINT `moodle_setup_info_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`), 
	  CONSTRAINT `moodle_setup_info_academyLocationId_FK` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location`(`id`) ) ENGINE=InnoDB DEFAULT 

CHARSET=utf8; 


INSERT INTO standard_master(`tableName`, `masterName`,`moduleName`, `whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
 VALUES ('moodle_setup_info', 'MOODLE_SETUP_INFO', 'Moodle Setup', 0, 0, '1', SYSDATE());
 
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, 

`fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES
('academyLocation', 'ACADEMY_LOCATION', @standardMasterMaxId, 'Varchar', '1', 1, 'academy_location', 'id','academyLocationName', 0, 0, 1, '1', SYSDATE()),
('hostURL', 'HOST_URL', @standardMasterMaxId, 'Varchar', '2', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('isDefault','IS_DEFAULT',@standardMasterMaxId,'Boolean','3',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE()),
('isActive','IS_ACTIVE',@standardMasterMaxId,'Boolean','4',0,NULL,NULL,NULL,0,0,1,'1',SYSDATE());

