CREATE TABLE `eval_group_hall_ticket` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `evaluationGroupId` BIGINT(20) NULL DEFAULT NULL,
  `admissionId` BIGINT(20) NULL DEFAULT NULL,
  `hallTicketNumber` VARCHAR(255) NULL DEFAULT NULL,
  `hallTicketPath` VARCHAR(512) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `eval_group_hall_ticket_fk1_idx` (`evaluationGroupId` ASC),
  INDEX `eval_group_hall_ticket_fk2_idx` (`admissionId` ASC),
  INDEX `eval_group_hall_ticket_fk3_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_eval_group_hall_ticket_1`
    FOREIGN KEY (`evaluationGroupId`)
    REFERENCES `evaluation_group` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_eval_group_hall_ticket_2`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_eval_group_hall_ticket_3`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT 
    ON UPDATE RESTRICT);