CREATE TABLE `evaluation_plan_academy_location` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `evaluationPlanId` bigint(20) NOT NULL,
  `academyLocationId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `plan_academy_location_unique_map` (`evaluationPlanId` ASC, `academyLocationId` ASC),
  KEY `fk_evaluation_plan_academy_location_1_idx` (`academyLocationId`),
  KEY `fk_evaluation_plan_academy_location_2_idx` (`evaluationPlanId`),
  KEY `fk_evaluation_plan_academy_location_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_evaluation_plan_academy_location_3_idx` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_evaluation_plan_academy_location_1_idx` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_evaluation_plan_academy_location_2_idx` FOREIGN KEY (`evaluationPlanId`) REFERENCES `evaluation_plan` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
