ALTER TABLE `eval_group_center` 
ADD COLUMN `courseVariantId` BIGINT(20) NULL DEFAULT NULL AFTER `evalSequenceDetailId`,
ADD COLUMN `sectionId` BIGINT(20) NULL DEFAULT NULL AFTER `courseVariantId`,
ADD UNIQUE INDEX `eval_group_center_unique_check` (`evaluationGroupId` ASC, `centerId` ASC, `evalSequenceDetailId` ASC, `courseVariantId` ASC, `sectionId` ASC),
ADD INDEX `fk_eval_group_center_cv_idx` (`courseVariantId` ASC),
ADD INDEX `fk_eval_group_center_section_idx` (`sectionId` ASC);
ALTER TABLE `eval_group_center` 
ADD CONSTRAINT `fk_eval_group_center_cv`
  FOREIGN KEY (`courseVariantId`)
  REFERENCES `course_variants` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_eval_group_center_section`
  FOREIGN KEY (`sectionId`)
  REFERENCES `sections` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;


ALTER TABLE `eval_group_sch_date` 
ADD COLUMN `courseVariantId` BIGINT(20) NULL DEFAULT NULL AFTER `evalSequenceDetailId`,
ADD COLUMN `sectionId` BIGINT(20) NULL DEFAULT NULL AFTER `courseVariantId`,
ADD UNIQUE INDEX `eval_group_sch_date_unique_check` (`evaluationGroupId` ASC, `scheduleDate` ASC, `evalSequenceDetailId` ASC, `courseVariantId` ASC, `sectionId` ASC),
ADD INDEX `fk_eval_group_sch_date_cv_idx` (`courseVariantId` ASC),
ADD INDEX `fk_eval_group_sch_date_section_idx` (`sectionId` ASC);
ALTER TABLE `eval_group_sch_date` 
ADD CONSTRAINT `fk_eval_group_sch_date_cv`
  FOREIGN KEY (`courseVariantId`)
  REFERENCES `course_variants` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_eval_group_sch_date_section`
  FOREIGN KEY (`sectionId`)
  REFERENCES `sections` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;



ALTER TABLE `group_schedule_batch` 
ADD COLUMN `courseVariantId` BIGINT(20) NULL DEFAULT NULL AFTER `evalSequenceDetailId`,
ADD COLUMN `sectionId` BIGINT(20) NULL DEFAULT NULL AFTER `courseVariantId`,
ADD UNIQUE INDEX `group_schedule_batch_unique_check` (`evaluationGroupId` ASC, `batchName` ASC, `evalSequenceDetailId` ASC, `courseVariantId` ASC, `sectionId` ASC),
ADD INDEX `fk_group_schedule_batch_cv_idx` (`courseVariantId` ASC),
ADD INDEX `fk_group_schedule_batch_section_idx` (`sectionId` ASC);
ALTER TABLE `group_schedule_batch` 
ADD CONSTRAINT `fk_group_schedule_batch_cv`
  FOREIGN KEY (`courseVariantId`)
  REFERENCES `course_variants` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_group_schedule_batch_section`
  FOREIGN KEY (`sectionId`)
  REFERENCES `sections` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  
  
  

ALTER TABLE `eval_group_sequences` 
ADD COLUMN `courseVariantId` BIGINT(20) NULL DEFAULT NULL AFTER `evalSequenceDetailId`,
ADD COLUMN `sectionId` BIGINT(20) NULL DEFAULT NULL AFTER `courseVariantId`,
ADD UNIQUE INDEX `eval_group_sequences_unique_check` (`evaluationGroupId` ASC, `evalSequenceDetailId` ASC, `courseVariantId` ASC, `sectionId` ASC),
ADD INDEX `fk_eval_group_sequences_cv_idx` (`courseVariantId` ASC),
ADD INDEX `fk_eval_group_sequences_section_idx` (`sectionId` ASC);
ALTER TABLE `eval_group_sequences` 
ADD CONSTRAINT `fk_eval_group_sequences_cv`
  FOREIGN KEY (`courseVariantId`)
  REFERENCES `course_variants` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_eval_group_sequences_section`
  FOREIGN KEY (`sectionId`)
  REFERENCES `sections` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  
  
  
ALTER TABLE `group_batch_seat_type` 
ADD COLUMN `courseVariantId` BIGINT(20) NULL DEFAULT NULL AFTER `evalSequenceDetailId`,
ADD COLUMN `sectionId` BIGINT(20) NULL DEFAULT NULL AFTER `courseVariantId`,
ADD UNIQUE INDEX `group_batch_seat_type_unique_check` (`progBatchSeatConfigId` ASC, `evalSequenceDetailId` ASC, `courseVariantId` ASC, `sectionId` ASC),
ADD INDEX `fk_group_batch_seat_type_cv_idx` (`courseVariantId` ASC),
ADD INDEX `fk_group_batch_seat_type_section_idx` (`sectionId` ASC);
ALTER TABLE `group_batch_seat_type` 
ADD CONSTRAINT `fk_group_batch_seat_type_cv`
  FOREIGN KEY (`courseVariantId`)
  REFERENCES `course_variants` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_group_batch_seat_type_section`
  FOREIGN KEY (`sectionId`)
  REFERENCES `sections` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;