CREATE TABLE `competitive_exam_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint(20) NOT NULL,
  `personId` bigint(20) NOT NULL,
  `examNameId` bigint(20) DEFAULT NULL,
  `enrollmentNumber` varchar(100) DEFAULT NULL,
  `examYearId` bigint(20) DEFAULT NULL,
  `score` varchar(100) DEFAULT NULL,
  `percentile` varchar(100) DEFAULT NULL,
  `rankOne` varchar(100) DEFAULT NULL,
  `rankTwo` varchar(100) DEFAULT NULL,
  `specialization` varchar(200) DEFAULT NULL,
  `remarks` text DEFAULT NULL,
  `whetherDeleted` bit(1) NOT NULL DEFAULT b'0',
  `version` decimal(10,0) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_competitive_exam_detail_lastUpdatedBy` (`lastUpdatedBy`),
  KEY `fk_competitive_exam_detail_applicantPersonId` (`applicantPersonId`),
  KEY `fk_competitive_exam_detail_personId` (`personId`),
  KEY `fk_competitive_exam_detail_examNameId` (`examNameId`),
  KEY `fk_competitive_exam_detail_examYearId` (`examYearId`),
  CONSTRAINT `fk_competitive_exam_detail_examNameId` FOREIGN KEY (`examNameId`) REFERENCES `examination_name` (`id`),
  CONSTRAINT `fk_competitive_exam_detail_examYearId` FOREIGN KEY (`examYearId`) REFERENCES `examination_year` (`id`),
  CONSTRAINT `fk_competitive_exam_detail_applicantPersonId` FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT `fk_competitive_exam_detail_personId` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
  CONSTRAINT `fk_competitive_exam_detail_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;