CREATE TABLE `question_paper_bank` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `paperCode` VARCHAR(45) NOT NULL,
  `programId` BIGINT(20) NOT NULL,
  `batchId` BIGINT(20) NOT NULL,
  `periodId` BIGINT(20) NOT NULL,
  `courseId` BIGINT(20) NOT NULL,
  `evaluationPlanId` BIGINT(20) NULL DEFAULT NULL,
  `evaluationDetailSequenceId` BIGINT(20) NULL DEFAULT NULL,
  `paperStatus` VARCHAR(45) NULL DEFAULT NULL,
  `dateOfAssignment` DATE NULL DEFAULT NULL,
  `dueDate` DATE NULL DEFAULT NULL,
  `submissionDate` DATE NULL DEFAULT NULL,
  `submittedById` BIGINT(20) NULL DEFAULT NULL,
  `assignmentStatus` VARCHAR(45) NULL DEFAULT NULL,
  `questionPaperUrl` VARCHAR(255) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `question_paper_bank_program_fk_idx` (`programId` ASC),
  INDEX `question_paper_bank_batch_fk_idx` (`batchId` ASC),
  INDEX `question_paper_bank_period_fk_idx` (`periodId` ASC),
  INDEX `question_paper_bank_course_fk_idx` (`courseId` ASC),
  INDEX `question_paper_bank_event_fk_idx` (`evaluationDetailSequenceId` ASC),
  INDEX `question_paper_bank_last_update_by_fk_idx` (`lastUpdatedBy` ASC),
  INDEX `question_paper_bank_submitted_by_fk_idx` (`submittedById` ASC),
  INDEX `question_paper_bank_evaluation_plan_fk_idx` (`evaluationPlanId` ASC),
  CONSTRAINT `question_paper_bank_program_fk`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `question_paper_bank_batch_fk`
    FOREIGN KEY (`batchId`)
    REFERENCES `batches` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `question_paper_bank_period_fk`
    FOREIGN KEY (`periodId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `question_paper_bank_course_fk`
    FOREIGN KEY (`courseId`)
    REFERENCES `courses` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `question_paper_bank_event_fk`
    FOREIGN KEY (`evaluationDetailSequenceId`)
    REFERENCES `eval_seq_detail` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `question_paper_bank_last_update_by_fk`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `question_paper_bank_submitted_by_fk`
    FOREIGN KEY (`submittedById`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `question_paper_bank_evaluation_plan_fk`
    FOREIGN KEY (`evaluationPlanId`)
    REFERENCES `evaluation_plan` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
