CREATE OR REPLACE VIEW `student_course_enrollment_search` AS
SELECT 
        ROUND((RAND() * 10000), 0) AS `id`,
        `p`.`id` AS `programId`,
        `p`.`programName` AS `programName`,
        `b`.`id` AS `batchId`,
        `b`.`batchName` AS `batchName`,
        IF(ISNULL(`pbpc`.`id`),
            -(1),
            `pbpc`.`id`) AS `periodId`,
        IF(ISNULL(`pbpc`.`id`),
            '-',
            `pbpc`.`programPeriodName`) AS `periodName`,
        IF(ISNULL(`cv`.`id`), -(1), `cv`.`id`) AS `courseVariantId`,
        IF(ISNULL(`cv`.`id`),
            '-',
            `cv`.`courseVariantCode`) AS `courseVariantCode`,
        `c`.`id` AS `courseId`,
        CONCAT(`c`.`courseCode`,
                ' / ',
                `c`.`courseName`) AS `courseName`,
        `s`.`id` AS `sectionId`,
        `s`.`sectionCode` AS `sectionCode`,
        `bc`.`whetherOptional` AS `courseType`,
        `c`.`assignSectionType` AS `sectionType`
    FROM
        ((((((`batch_courses` `bc`
        LEFT JOIN (`sections` `s`
        LEFT JOIN `prog_batch_period_config` `pbpc` ON ((`s`.`periodId` = `pbpc`.`id`))) ON ((`pbpc`.`programBatchId` = `bc`.`batchId`)))
        LEFT JOIN `courses` `c` ON (((`bc`.`courseId` = `c`.`parentCourseId`)
            OR (`bc`.`courseId` = `c`.`id`))))
        LEFT JOIN `program_batch_course_param` `pbcp` ON ((`c`.`id` = `pbcp`.`courseId`)))
        LEFT JOIN `course_variants` `cv` ON ((`pbcp`.`courseVarientId` = `cv`.`id`)))
        LEFT JOIN `batches` `b` ON ((`pbpc`.`programBatchId` = `b`.`id`)))
        LEFT JOIN `programs` `p` ON ((`b`.`programId` = `p`.`id`)))
    WHERE
        (`c`.`assignSectionType` = 'ProgramBatchSection') 
    UNION ALL SELECT 
        ROUND((RAND() * 10000), 0) AS `id`,
        `p`.`id` AS `programId`,
        `p`.`programName` AS `programName`,
        `b`.`id` AS `batchId`,
        `b`.`batchName` AS `batchName`,
        IF(ISNULL(`pbpc`.`id`),
            -(1),
            `pbpc`.`id`) AS `periodId`,
        IF(ISNULL(`pbpc`.`id`),
            '-',
            `pbpc`.`programPeriodName`) AS `periodName`,
        IF(ISNULL(`cv`.`id`), -(1), `cv`.`id`) AS `courseVariantId`,
        IF(ISNULL(`cv`.`id`),
            '-',
            `cv`.`courseVariantCode`) AS `courseVariantCode`,
        `c`.`id` AS `courseId`,
        CONCAT(`c`.`courseCode`,
                ' / ',
                `c`.`courseName`) AS `courseName`,
        `s`.`id` AS `sectionId`,
        `s`.`sectionCode` AS `sectionCode`,
        `pbcp`.`whetherOptional` AS `courseType`,
        `c`.`assignSectionType` AS `sectionType`
    FROM
        ((((((`sections` `s`
        LEFT JOIN `course_variants` `cv` ON ((`s`.`courseVariantId` = `cv`.`id`)))
        LEFT JOIN `program_batch_course_param` `pbcp` ON ((`cv`.`id` = `pbcp`.`courseVarientId`)))
        LEFT JOIN `prog_batch_period_config` `pbpc` ON ((`pbpc`.`id` = `pbcp`.`progBatchPeriodConfigId`)))
        LEFT JOIN `batches` `b` ON ((`pbpc`.`programBatchId` = `b`.`id`)))
        LEFT JOIN `programs` `p` ON ((`b`.`programId` = `p`.`id`)))
        LEFT JOIN `courses` `c` ON ((`cv`.`courseId` = `c`.`id`)))