-- course_session_diary
CREATE TABLE `course_session_diary` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `componentId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `sessionDate` date DEFAULT NULL,
  `sessionNumber` int(15) DEFAULT NULL,
  `timeFrom` datetime DEFAULT NULL,
  `timeTo` datetime DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `topics` text DEFAULT NULL,
  `publishToStudent` bit(1) DEFAULT b'0',
  `publishToParent` bit(1) DEFAULT b'0',
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_course_session_diary_academyLocationId` (`academyLocationId`),
  KEY `fk_course_session_diary_courseId` (`courseId`),
  KEY `fk_course_session_diary_componentId` (`componentId`),
  KEY `fk_course_session_diary_courseVariantId` (`courseVariantId`),
  KEY `fk_course_session_diary_facultyId` (`facultyId`),
  KEY `fk_course_session_diary_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_course_session_diary_academyLocationId` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
  CONSTRAINT `fk_course_session_diary_courseId` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`),
  CONSTRAINT `fk_course_session_diary_componentId` FOREIGN KEY (`componentId`) REFERENCES `course_components` (`id`),
  CONSTRAINT `fk_course_session_diary_courseVariantId` FOREIGN KEY (`courseVariantId`) REFERENCES `course_variants` (`id`),
  CONSTRAINT `fk_course_session_diary_facultyId` FOREIGN KEY (`facultyId`) REFERENCES `staffs` (`userId`),
  CONSTRAINT `fk_course_session_diary_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- course_session_diary_document
CREATE TABLE `course_session_diary_document` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentId` bigint(20) NOT NULL,
  `sessionDiaryId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_course_session_diary_document_documentId` (`documentId`),
  KEY `fk_course_session_diary_document_sessionDiaryId` (`sessionDiaryId`),
  KEY `fk_course_session_diary_document_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_course_session_diary_document_documentId` FOREIGN KEY (`sessionDiaryId`) REFERENCES `course_session_diary` (`id`),
  CONSTRAINT `fk_course_session_diary_document_sessionDiaryId` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`),
  CONSTRAINT `fk_course_session_diary_document_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Custom Data
CREATE TABLE `course_session_diary_cd` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `courseSessionDiaryId` bigint(20) DEFAULT NULL,
  `cf1` varchar(255) DEFAULT NULL,
  `cf2` varchar(255) DEFAULT NULL,
  `cf3` varchar(255) DEFAULT NULL,
  `cf4` varchar(255) DEFAULT NULL,
  `cf5` varchar(255) DEFAULT NULL,
  `cf6` varchar(255) DEFAULT NULL,
  `cf7` varchar(255) DEFAULT NULL,
  `cf8` varchar(255) DEFAULT NULL,
  `cf9` varchar(255) DEFAULT NULL,
  `cf10` varchar(255) DEFAULT NULL,
  `cf11` bigint(20) DEFAULT NULL,
  `cf12` bigint(20) DEFAULT NULL,
  `cf13` bigint(20) DEFAULT NULL,
  `cf14` date DEFAULT NULL,
  `cf15` date DEFAULT NULL,
  `cf16` tinyint(1) DEFAULT NULL,
  `cf17` tinyint(1) DEFAULT NULL,
  `cf18` varchar(255) DEFAULT NULL,
  `cf19` varchar(255) DEFAULT NULL,
  `version` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `fk_course_session_diary_cd_id` (`courseSessionDiaryId`),
  KEY `fk_course_session_diary_cd_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_course_session_diary_cd_id` FOREIGN KEY (`courseSessionDiaryId`) REFERENCES `course_session_diary` (`id`),
  CONSTRAINT `fk_course_session_diary_cd_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
