CREATE TABLE `event_meeting_minutes` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `eventId` bigint(20) DEFAULT NULL,
  `minuteTakerId` bigint(20) DEFAULT NULL,
  `minuteDate` date DEFAULT NULL,
  `minuteSubject` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_event_meeting_minutes_eventId_idx` (`eventId`),
  KEY `fk_event_meeting_minutes_minuteTakerId_idx` (`minuteTakerId`),
  KEY `fk_event_meeting_minutes_lastUpdatedBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_event_meeting_minutes_eventId` FOREIGN KEY (`eventId`) REFERENCES `resource_bookings` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_event_meeting_minutes_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_event_meeting_minutes_minuteTakerId` FOREIGN KEY (`minuteTakerId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


CREATE TABLE `event_meeting_minutes_task` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `minuteId` bigint(20) DEFAULT NULL,
  `assignDate` date DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `type` varchar(15) DEFAULT NULL,
  `description` text,
  `ownerId` bigint(20) DEFAULT NULL,
  `status` varchar(15) DEFAULT NULL,
  `dueDate` date DEFAULT NULL,
  `completionDate` date DEFAULT NULL,
  `noOfDaysOverdue` int(3) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_event_meeting_minutes_task_minuteId_idx` (`minuteId`),
  KEY `fk_event_meeting_minutes_task_ownerId_idx` (`ownerId`),
  KEY `fk_event_meeting_minutes_task_lastUpdatedBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_event_meeting_minutes_task_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_event_meeting_minutes_task_minuteId` FOREIGN KEY (`minuteId`) REFERENCES `event_meeting_minutes` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_event_meeting_minutes_task_ownerId` FOREIGN KEY (`ownerId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


CREATE TABLE `event_meeting_minutes_document` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `minuteId` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_event_meeting_minutes_document_minuteId_idx` (`minuteId`),
  KEY `fk_event_meeting_minutes_document_documentId_idx` (`documentId`),
  KEY `fk_event_meeting_minutes_document_lastUpdatedBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_event_meeting_minutes_document_documentId` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_event_meeting_minutes_document_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_event_meeting_minutes_document_minuteId` FOREIGN KEY (`minuteId`) REFERENCES `event_meeting_minutes` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
