CREATE TABLE `enquiry_mode` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_enquiryMode_updateby` (`lastUpdatedBy`),
  CONSTRAINT `fk_enquiryMode_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE `enquiry_mode` 
ADD UNIQUE INDEX `unique_code_value` (`itemCode` ASC, `itemValue` ASC);

SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'enquiry_mode','ENQUIRY_MODE','Enquiry','COMMON_MASTER',0,0,NULL,1,SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'ITEM_CODE', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'value', 'ITEM_VALUE', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());

/*********Enquiry Mode********/
insert into enquiry_mode (`itemCode`,`itemValue`,`lastUpdate`,`lastUpdatedBy`) values('WALK_IN','Walk-In',SYSDATE(),1);
insert into enquiry_mode (`itemCode`,`itemValue`,`lastUpdate`,`lastUpdatedBy`) values('ONLINE','Online',SYSDATE(),1);
insert into enquiry_mode (`itemCode`,`itemValue`,`lastUpdate`,`lastUpdatedBy`) values('TELEPHONE','Telephone',SYSDATE(),1);