CREATE TABLE `medical_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  `scheme` varchar(255) DEFAULT NULL,
  `option1` varchar(255) DEFAULT NULL,
  `principleMember` varchar(255) DEFAULT NULL,
  `membershipNumber` varchar(255) DEFAULT NULL,
  `validTill` date DEFAULT NULL,
  `bloodType` varchar(20) DEFAULT NULL,
  `childDependentCode` varchar(255) DEFAULT NULL,
  `familyPractionerName` varchar(255) DEFAULT NULL,
  `familyPractionerCountryCode` varchar(10) DEFAULT NULL,
  `familyPractionerContactNumber` varchar(20) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_medical_details_applicantPersonId_idx` (`applicantPersonId`),
  KEY `fk_medical_details_personId_idx` (`personId`),
  KEY `fk_medical_details_lastUpdatedBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_medical_details_applicantPersonId` FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_medical_details_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_medical_details_personId` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;