
DELIMITER //

CREATE TRIGGER research_type_after_insert
AFTER INSERT
   ON research_type FOR EACH ROW
BEGIN
      -- Insert record into other table
INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('Past History',NEW.itemValue, 'Research Details', 'STUDENT', NEW.id,
   'select T4.path AS value from research_type T1 LEFT JOIN person_research_details T2 ON T1.id = T2.researchTypeId 
LEFT JOIN person_research_documents T3 ON T3.personResearchId = T2.id LEFT JOIN documents T4 ON T4.id = T3.documentId 
where T2.personId = $param1 and T1.itemValue = $param2 and T2.whetherDeleted = false',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);

INSERT INTO bulk_document_group (groupName, documentName, documentType, personType, documentId, tableQuery, 
   rootPath, lastUpdate, lastUpdatedBy)
   VALUES ('Past History',NEW.itemValue, 'Research Details', 'EMPLOYEE', NEW.id,
   'select T4.path AS value from research_type T1 LEFT JOIN person_research_details T2 ON T1.id = T2.researchTypeId 
LEFT JOIN person_research_documents T3 ON T3.personResearchId = T2.id LEFT JOIN documents T4 ON T4.id = T3.documentId 
where T2.personId = $param1 and T1.itemValue = $param2 and T2.whetherDeleted = false',
'document.constant.base.dir',NEW.lastUpdate,NEW.lastUpdatedBy);

END; //

DELIMITER ;

DELIMITER //

CREATE TRIGGER research_type_after_update
AFTER UPDATE
   ON research_type FOR EACH ROW
BEGIN
   UPDATE bulk_document_group SET documentName = NEW.itemValue, lastUpdate = NEW.lastUpdate,
   lastUpdatedBy = NEW.lastUpdatedBy WHERE documentName = OLD.itemValue
   and documentId = OLD.id;
END; //

DELIMITER ;

DELIMITER //

CREATE TRIGGER research_type_after_delete
AFTER DELETE
   ON research_type FOR EACH ROW
BEGIN
   DELETE FROM bulk_document_group WHERE documentName = OLD.itemValue
   and documentId = OLD.id;
END; //

DELIMITER ; 