CREATE TABLE `identity_manager` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `academyLocationId` BIGINT(20) NOT NULL,
  `username` VARCHAR(255) NOT NULL,
  `password` VARCHAR(255) NOT NULL,
  `customerIdentifier` VARCHAR(255) NOT NULL,
  `tokenURL` VARCHAR(255) NOT NULL,
  `identityURL` VARCHAR(255) NOT NULL,
  `isActive` BIT(1) NULL DEFAULT NULL,
  `isDefault` BIT(1) NULL DEFAULT b'0',
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_academyLocationId_idx` (`academyLocationId` ASC),
  INDEX `fk_lastUpdateById_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_academyLocationId`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_lastUpdateById`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
 ENGINE=InnoDB DEFAULT CHARSET=utf8;

SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'identity_manager','IDENTITY_MANAGER','General Setup','MASTER_WITH_AL',0,0,NULL,1,SYSDATE());


INSERT INTO `standard_master_items` (`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
VALUES 
('userName', 'USER_NAME', @standardMasterMaxId+1, 'Varchar', '2', 0, 0, 0, 0, '1', SYSDATE()),
('password', 'PASSWORD', @standardMasterMaxId+1, 'Varchar', '3', 0, 0, 0, 0, '1', SYSDATE()),
('customerIdentifier', 'CUSTOMER_IDENTIFIER', @standardMasterMaxId+1, 'Varchar', '4', 0, 0, 0, 0, '1', SYSDATE()),
('tokenURL', 'TOKEN_URL', @standardMasterMaxId+1, 'Varchar', '5', 0, 0, 0, 0, '1', SYSDATE()),
('identityURL', 'IDENTITY_URL', @standardMasterMaxId+1, 'Varchar', '6', 0, 0, 0, 0, '1', SYSDATE()),
('isActive', 'IS_ACTIVE', @standardMasterMaxId+1, 'Boolean', '7', 0, 0, 0, 1, '1', SYSDATE()),
('isDefault', 'IS_DEFAULT', @standardMasterMaxId+1, 'Boolean', '8', 0, 0, 0, 1, '1', SYSDATE());



INSERT INTO `standard_master_items` (`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`,`fkFieldName`,`fkDisplayField` ,`whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
VALUES ('academyLocation', 'ACADEMY_LOCATION', @standardMasterMaxId+1, 'Varchar', '1',1,'academy_location','id','academyLocationName', 0, 0, 0, '1', SYSDATE())





