SET SQL_SAFE_UPDATES = 0;
CREATE TABLE `student_hostel_requirement` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `whetherHostelApplicable` TINYINT(1) NULL DEFAULT '0',
  `dietaryRequirements` VARCHAR(255) NULL DEFAULT NULL,
  `foodAllergies` VARCHAR(255) NULL DEFAULT NULL,
  `sleepingDisorder` VARCHAR(255) NULL DEFAULT NULL,
  `anyMedicalNeedsOrSomething` VARCHAR(255) NULL DEFAULT NULL,
  `personId` BIGINT(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NULL DEFAULT NULL,
   `version` bigint(20) NULL DEFAULT 0,
   `whetherDeleted` bit(1) NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_student_hostel_personal_requirement`
    FOREIGN KEY (`personId`)
    REFERENCES `persons` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

INSERT INTO `student_hostel_requirement` (`whetherHostelApplicable`, `dietaryRequirements`, `foodAllergies`,`sleepingDisorder`,`anyMedicalNeedsOrSomething`,`personId`)
select `whetherHostelApplicable`, `dietaryRequirements`, `foodAllergies`, `sleepingDisorder`, `anyMedicalNeedsOrSomething`, `id` as `personId` 
from `persons` where `whetherHostelApplicable` is not NULL and `whetherHostelApplicable` = 1;

ALTER TABLE `persons`
  DROP COLUMN `whetherHostelApplicable`,
  DROP COLUMN `dietaryRequirements`,
  DROP COLUMN `foodAllergies`,
  DROP COLUMN `sleepingDisorder`,
  DROP COLUMN `anyMedicalNeedsOrSomething`;

SET SQL_SAFE_UPDATES = 1;