CREATE TABLE `offline_payment_instrument` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `offlinePaymentHeaderId` bigint(20) DEFAULT NULL,
  `paymentMode` bigint(20) DEFAULT NULL,
  `amount` double(20,2) NOT NULL,
  `instrumentNo` varchar(255) DEFAULT NULL,
  `instrumentDate` date DEFAULT NULL,
  `instrumentBank` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefofflinePaymentHeaderId618` (`offlinePaymentHeaderId`),
  KEY `Refusers2019`(`lastUpdatedBy`),
  KEY `Refpaymentmode2019` (`paymentMode`),
  KEY `Refbank2019` (`instrumentBank`),
  CONSTRAINT `bankdrawnon_master2019` FOREIGN KEY (`instrumentBank`) REFERENCES `bank_drawn_on_master` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `paymentmode2019` FOREIGN KEY (`paymentMode`) REFERENCES `fee_payment_modes` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `offlinePaymentHeader618` FOREIGN KEY (`offlinePaymentHeaderId`) REFERENCES `offline_payment_header` (`id`),
  CONSTRAINT `users2019` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=694 DEFAULT CHARSET=utf8;
