CREATE TABLE `manage_target_tertiary` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` BIGINT(20) NULL DEFAULT NULL,
  `intakeYearId` BIGINT(20) NULL DEFAULT NULL,
  `manageTargetType` VARCHAR(255) NULL DEFAULT NULL,
  `actualTarget` BIGINT(20) NULL DEFAULT NULL,
  `programId` BIGINT(20) NULL DEFAULT NULL,
  `staffId` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_manage_target_tertiary_al`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_manage_target_tertiary_intake`
    FOREIGN KEY (`intakeYearId`)
    REFERENCES `intake_year` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_manage_target_tertiary_program`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_manage_target_tertiary_staff`
    FOREIGN KEY (`staffId`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_manage_target_tertiary_last_updated_by`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);