DROP procedure IF EXISTS `student_publish_data`;

DELIMITER $$
CREATE PROCEDURE `student_publish_data`(IN instudentId BIGINT(20), IN firstResult INT(11), IN maxResult INT(11))
BEGIN

START TRANSACTION;
if firstResult is null then set firstResult = 0; end if;
if maxResult is null then set maxResult = 1000; end if;

BLOCK1: BEGIN

	SELECT 
        FUNC_INC_VAR_SESSION() AS id,
        hallTicket.admissionId AS admissionId,
        admission.studentId AS studentId,
        hallTicket.reportType AS reportType,
        if(student_finance_hold.status='ACTIVE','',hallTicket.hallTicketPath) AS documentPath,
        if(student_finance_hold.status='ACTIVE','',hallTicket.hallTicketNumber) AS documentName,
        DATE_FORMAT(hallTicket.lastUpdate,'%Y-%m-%d') AS publishDate
        
		FROM eval_group_hall_ticket as hallTicket
        JOIN admission ON hallTicket.admissionId = admission.id
        left join student_finance_hold on admission.studentId=student_finance_hold.studentId
        left join finance_hold_criteria on student_finance_hold.financeHoldCriteriaId=finance_hold_criteria.id
        and student_finance_hold.status='ACTIVE' and finance_hold_criteria.holdType='HALL_TICKET_PUBLISH'
        and student_finance_hold.programBatchPeriodConfigId=hallTicket.periodId
		WHERE
        hallTicket.isPublishHallTicket = true
            AND hallTicket.reportType = 'HALL_TICKET' 
            AND admission.studentId= instudentId
            

	UNION SELECT 
        FUNC_INC_VAR_SESSION() AS id,
        jobDetails.admissionId AS admissionId,
        admission.studentId AS studentId,
        'MARKSHEET' AS reportType,
        if(student_finance_hold.status='ACTIVE','',jobDetails.marksheetPath) AS documentPath,
        if(student_finance_hold.status='ACTIVE','',subLevel.marksheetJobSubLevelName) AS documentName,
        subLevel.publishDate AS publishDate
    FROM marksheet_job_details as jobDetails
        JOIN marksheet_job_sub_level as subLevel ON jobDetails.marksheetJobSubLevelId = subLevel.id
        left join marksheet_job on subLevel.marksheetJobId=marksheet_job.id
        JOIN admission ON jobDetails.admissionId = admission.id
        left join student_finance_hold on admission.studentId=student_finance_hold.studentId
         and marksheet_job.periodId=student_finance_hold.programBatchPeriodConfigId
        left join finance_hold_criteria on student_finance_hold.financeHoldCriteriaId=finance_hold_criteria.id
        and student_finance_hold.status='ACTIVE' and finance_hold_criteria.holdType='RESULT_PUBLISH'
        WHERE
        jobDetails.isPublishMarksheet = true
        AND admission.studentId= instudentId
        

    UNION SELECT 
        FUNC_INC_VAR_SESSION() AS id,
        details.admissionId AS admissionId,
        admission.studentId AS studentId,
        'MARKSHEET' AS reportType,
        details.marksheetPath AS documentPath,
        details.marksheetPath AS documentName,
        details.publishDate AS publishDate
    FROM
        evaluation_group_marksheet as markSheet
        JOIN evaluation_group_marksheet_details as details ON markSheet.id = details.evaluationGroupMarksheetId
        JOIN admission ON details.admissionId = admission.id
        
    WHERE
        details.isPublishMarksheet = true
        AND admission.studentId= instudentId


    UNION SELECT 
        FUNC_INC_VAR_SESSION() AS id,
        examDoc.admissionId AS admissionId,
        admission.studentId AS studentId,
        examDoc.reportType AS reportType,
        examDoc.documentPath AS documentPath,
        examDoc.documentName AS documentName,
        examDoc.publishDate AS publishDate
    FROM
        examination_report_document as examDoc
        JOIN admission ON examDoc.admissionId = admission.id
    WHERE
        examDoc.isPublish = true
        AND admission.studentId= instudentId
        LIMIT firstResult, maxResult;
 END BLOCK1;

COMMIT;    
END$$

DELIMITER ;

