DROP view IF EXISTS `application_fee_view`;

CREATE VIEW `application_fee_view`  AS
    SELECT 
        SUM(`bfprs`.`billableAmount`) AS `INVOICES`,
        (SELECT 
                SUM(`receipt_header`.`amount`)
            FROM
                `receipt_header`
            WHERE
                ((`receipt_header`.`applicantId` = `app`.`id`)
                    AND (`receipt_header`.`academyLocationId` = `al`.`id`))) AS `RECEIPTS`,
        (SUM(`bfprs`.`billableAmount`) - (SELECT 
                SUM(`receipt_header`.`amount`)
            FROM
                `receipt_header`
            WHERE
                ((`receipt_header`.`applicantId` = `app`.`id`)
                    AND (`receipt_header`.`academyLocationId` = `al`.`id`)))) AS `OUTSTANDING_AMOUNT`,
        SUM(`bfprs`.`balanceAmount`) AS `OUTSTANDING_AMOUNT_BILL_SETTLED`,
        `app`.`id` AS `APPLICATION_ID`,
        `app`.`code` AS `APPLICATION_CODE`,
        `app`.`applicationCreatedOn` as `APPLICATION_DATE`, 
        `ap`.`printName` AS `APPLICANT_NAME`,
        `p`.`programName` AS `PROGRAM_NAME`,
        `b`.`batchName` AS `BATCH_NAME`,
        `iy`.`itemCode` AS `INTAKE_YEAR`,
        `iy`.`id` AS `intakeYearId`,
        `al`.`id` AS `ACADEMY_LOCATION_ID`,
        `ac`.`academyName` AS `ACADEMY_NAME`,
        `lc`.`locationName` AS `LOCATION_NAME`,
        `p`.`id` AS `PROGRAM_ID`,
        `b`.`id` AS `BATCH_ID`,
        `al`.`displayName` AS `ACADEMY_LOCATION_NAME`
    FROM
        ((((((((((`bill_header` `bh`
        LEFT JOIN `bill_fee_plan_rule_stage` `bfprs` ON ((`bh`.`id` = `bfprs`.`billId`)))
        LEFT JOIN `academy_location` `al` ON ((`bh`.`academyLocationId` = `al`.`id`)))
        LEFT JOIN `academies` `ac` ON ((`al`.`academyId` = `ac`.`id`)))
        LEFT JOIN `locations` `lc` ON ((`al`.`locationId` = `lc`.`id`)))
        LEFT JOIN `prog_batch_seat_config` `pbsc` ON ((`pbsc`.`id` = `bh`.`programBatchSeatConfigId`)))
        LEFT JOIN `batches` `b` ON ((`pbsc`.`programBatchId` = `b`.`id`)))
        LEFT JOIN `programs` `p` ON ((`b`.`programId` = `p`.`id`)))
        LEFT JOIN `intake_year` `iy` ON ((`b`.`intakeYearId` = `iy`.`id`)))
        LEFT JOIN `application` `app` ON ((`bh`.`applicantId` = `app`.`id`)))
        LEFT JOIN `applicant_person` `ap` ON ((`app`.`applicantPersonId` = `ap`.`id`)))
    WHERE
        ((`bh`.`applicantId` IS NOT NULL)
            AND (`bh`.`billStatus` <> 'CANCELLED')
            AND (`bh`.`raiseBillCategory` = 'BILL_RECEIVABLE'))
    GROUP BY `app`.`id` , `al`.`id` 