/********SG Hours******/
CREATE TABLE `sg_hours` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `itemCode_UNIQUE` (`itemCode`),
  UNIQUE KEY `itemValue_UNIQUE` (`itemValue`),
  KEY `fk_sg_hours_updateby` (`lastUpdatedBy`),
  CONSTRAINT `fk_sg_hours_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



/********SG Minute******/
CREATE TABLE `sg_minute` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `itemCode_UNIQUE` (`itemCode`),
  UNIQUE KEY `itemValue_UNIQUE` (`itemValue`),
  KEY `fk_sg_minute_updateby` (`lastUpdatedBy`),
  CONSTRAINT `fk_sg_minute_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


ALTER TABLE `sg_reason_for_visit` 
CHANGE COLUMN `visitDurationHours` `visitDurationHourId` BIGINT(20) NULL DEFAULT NULL ,
CHANGE COLUMN `visitDurationMinutes` `visitDurationMinuteId` BIGINT(20) NULL DEFAULT NULL ,
ADD INDEX `fk_sg_hoursId_idx` (`visitDurationHourId` ASC),
ADD INDEX `fk_sg_minutesd_idx` (`visitDurationMinuteId` ASC);
ALTER TABLE `sg_reason_for_visit` 
ADD CONSTRAINT `fk_sg_hoursId`
  FOREIGN KEY (`visitDurationHourId`)
  REFERENCES `sg_hours` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_sg_minutesd`
  FOREIGN KEY (`visitDurationMinuteId`)
  REFERENCES `sg_minute` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  