DELIMITER $$

DROP PROCEDURE IF EXISTS add_enrollCourseStatus_column $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE add_enrollCourseStatus_column()

BEGIN
-- Add the email_address column to the enrollCourseStatus table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='student_course_enrollment' 
  AND column_name='enrollCourseStatus')) THEN
  
    ALTER TABLE `student_course_enrollment` 
ADD COLUMN `enrollCourseStatus` VARCHAR(50) NULL DEFAULT 'Regular' AFTER `transferCreditStatus`;

END IF;

END $$

-- Execute the stored procedure
CALL add_enrollCourseStatus_column() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS add_enrollCourseStatus_column $$
 
DELIMITER ;