DELIMITER $$

DROP PROCEDURE IF EXISTS bill_settings $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE bill_settings()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='bill_settings' 
  AND column_name='futureDateAllowInDays')) THEN
  
  -- ALTER TABLE QUERY
  ALTER TABLE `bill_settings` 
  ADD COLUMN `futureDateAllowInDays` INT(4) NULL DEFAULT NULL AFTER `backDateAllowInDays`;
    
  
  END IF;

END $$

-- Execute the stored procedure
CALL bill_settings $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS bill_settings $$
 
DELIMITER ;