DELIMITER $$

DROP PROCEDURE IF EXISTS V202001071912__Update_TIME_TABLE_DELETE_FOR_MOTHER_RCPNT $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001071912__Update_TIME_TABLE_DELETE_FOR_MOTHER_RCPNT()

BEGIN
  set sql_safe_updates=0;
  -- Add the email_address column to the email table, if it doesn't already exist
  IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_DELETE_FOR_MOTHER_RCPNT')) THEN
    
	

SET @ttfDtProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_DELETE_FOR_MOTHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FACULTY_FIRST_NAME,
    p.lastName AS FACULTY_LAST_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    sal.salutationName AS SALUTATION_NAME,
	(select group_concat(distinct deviceTokenId) from fire_base_persons_info f where ps.userId = f.userId)  AS DEVICE_ID,
	T1.reasonForSubstituteSession AS SUBSTITUTE_REASON
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    students T2 ON T2.userId = T1.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    persons T5 ON T5.id = T2.personId
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
       LEFT JOIN
    staffs s ON s.userId = T1.facultyId
       LEFT JOIN
    persons p ON p.id = s.personId
      LEFT  JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
       LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    person_relationships AS pr ON pr.personId = T5.id
        INNER JOIN
    persons AS T7 ON T7.id = pr.relatedPersonId
  		LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN
	parents ps on ps.personId = T7.id
WHERE
    T1.id IN (namedParams) AND pr.relationship = 'MOTHER'" WHERE `dataProviderId`=@ttfDtProviderId;
    
    
    
    UPDATE `sql_dtprovider` SET `jsonString`='{
 "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "SESSION_DATE",
            "resultKey": "SESSION_DATE",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 8,
            "value": "SLOT_FROM",
            "resultKey": "SLOT_FROM",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "SLOT_TO",
            "resultKey": "SLOT_TO",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "firstName",
            "resultKey": "FACULTY_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "lastName",
            "resultKey": "FACULTY_LAST_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "courseCodeToBePrinted",
            "resultKey": "COURSE_CODE",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "nameToBePrinted",
            "resultKey": "COURSE_NAME_TO_BE_PRINTED",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "resourceName",
            "resultKey": "ROOM_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "reasonForSubstituteSession",
            "resultKey": "SUBSTITUTE_REASON",
            "displayCode": "",
            "displayOrder": 15
        }
    ]}' WHERE `dataProviderId`=@ttfDtProviderId;

END IF;

IF EXISTS ((SELECT id FROM msg_template_config WHERE `code`='Time Table Delete For Parent Guardian 2')) THEN

SET @addUserId=(SELECT id FROM msg_template_config WHERE `code`='Time Table Delete For Parent Guardian 2');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;SALUTATION_NAME&quot;]&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Timetable for the $recipientData[&quot;COURSE_NAME_TO_BE_PRINTED&quot;] of $recipientData[&quot;SESSION_DATE&quot;] $recipientData[&quot;SLOT_FROM&quot;] $recipientData[&quot;SLOT_TO&quot;] and $recipientData[&quot;FACULTY_FIRST_NAME&quot;] $recipientData[&quot;FACULTY_LAST_NAME&quot;] in $recipientData[&quot;ROOM_NAME&quot;] has been cancelled, because of the reason mention below: <br>
$recipientData["SUBSTITUTE_REASON"] <br><br>
Regards <br>
$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]
            </span></span></p>

			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="https://www.serosoft.com/mailer/academiaerp-logo-red.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@addUserId and `msgDeliveryModeId` in (1,4);

UPDATE `msg_template` SET `msgContent`='Dear $recipientData[&quot;SALUTATION_NAME&quot;] $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;], Timetable for the $recipientData[&quot;COURSE_NAME_TO_BE_PRINTED&quot;] of $recipientData[&quot;SESSION_DATE&quot;] $recipientData[&quot;SLOT_FROM&quot;] $recipientData[&quot;SLOT_TO&quot;] and $recipientData[&quot;FACULTY_FIRST_NAME&quot;] $recipientData[&quot;FACULTY_LAST_NAME&quot;] in $recipientData[&quot;ROOM_NAME&quot;] has been cancelled, because of the reason: $recipientData["SUBSTITUTE_REASON"].' WHERE `msgTemplateConfigId`=@addUserId and `msgDeliveryModeId` in (2,6);

END IF;

IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_DELETE_FOR_FATHER_RCPNT')) THEN
    

SET @ttfDtProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_DELETE_FOR_FATHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FACULTY_FIRST_NAME,
    p.lastName AS FACULTY_LAST_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    sal.salutationName AS SALUTATION_NAME,
	(select group_concat(distinct deviceTokenId) from fire_base_persons_info f where ps.userId = f.userId)  AS DEVICE_ID,
	T1.reasonForSubstituteSession AS SUBSTITUTE_REASON
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    students T2 ON T2.userId = T1.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    persons T5 ON T5.id = T2.personId
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
      LEFT  JOIN
    staffs s ON s.userId = T1.facultyId
       LEFT JOIN
    persons p ON p.id = s.personId
       LEFT JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
       LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    person_relationships AS pr ON pr.personId = T5.id
        INNER JOIN
    persons AS T7 ON T7.id = pr.relatedPersonId
  		LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN
	parents ps on ps.personId = T7.id
WHERE
    T1.id IN (namedParams) AND pr.relationship = 'FATHER'" WHERE `dataProviderId`=@ttfDtProviderId;
    
    
    
    UPDATE `sql_dtprovider` SET `jsonString`='{
 "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "SESSION_DATE",
            "resultKey": "SESSION_DATE",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 8,
            "value": "SLOT_FROM",
            "resultKey": "SLOT_FROM",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "SLOT_TO",
            "resultKey": "SLOT_TO",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "firstName",
            "resultKey": "FACULTY_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "lastName",
            "resultKey": "FACULTY_LAST_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "courseCodeToBePrinted",
            "resultKey": "COURSE_CODE",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "nameToBePrinted",
            "resultKey": "COURSE_NAME_TO_BE_PRINTED",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "resourceName",
            "resultKey": "ROOM_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "reasonForSubstituteSession",
            "resultKey": "SUBSTITUTE_REASON",
            "displayCode": "",
            "displayOrder": 15
        }
    ]}' WHERE `dataProviderId`=@ttfDtProviderId;


END IF;

IF EXISTS ((SELECT id FROM msg_template_config WHERE `code`='Time Table Delete For Parent Guardian 1')) THEN

SET @addUserId=(SELECT id FROM msg_template_config WHERE `code`='Time Table Delete For Parent Guardian 1');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;SALUTATION_NAME&quot;]&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Timetable for the $recipientData[&quot;COURSE_NAME_TO_BE_PRINTED&quot;] of $recipientData[&quot;SESSION_DATE&quot;] $recipientData[&quot;SLOT_FROM&quot;] $recipientData[&quot;SLOT_TO&quot;] and $recipientData[&quot;FACULTY_FIRST_NAME&quot;] $recipientData[&quot;FACULTY_LAST_NAME&quot;] in $recipientData[&quot;ROOM_NAME&quot;] has been cancelled, because of the reason mention below: <br>
$recipientData["SUBSTITUTE_REASON"] <br><br>
Regards <br>
$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]
            </span></span></p>

			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="https://www.serosoft.com/mailer/academiaerp-logo-red.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@addUserId and `msgDeliveryModeId` in (1,4);

UPDATE `msg_template` SET `msgContent`='Dear $recipientData[&quot;SALUTATION_NAME&quot;] $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;], Timetable for the $recipientData[&quot;COURSE_NAME_TO_BE_PRINTED&quot;] of $recipientData[&quot;SESSION_DATE&quot;] $recipientData[&quot;SLOT_FROM&quot;] $recipientData[&quot;SLOT_TO&quot;] and $recipientData[&quot;FACULTY_FIRST_NAME&quot;] $recipientData[&quot;FACULTY_LAST_NAME&quot;] in $recipientData[&quot;ROOM_NAME&quot;] has been cancelled, because of the reason: $recipientData["SUBSTITUTE_REASON"].' WHERE `msgTemplateConfigId`=@addUserId and `msgDeliveryModeId` in (2,6);

END IF;

IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_DELETE_FOR_STUDENT_RCPNT')) THEN

SET @ttfDtProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_DELETE_FOR_STUDENT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FACULTY_FIRST_NAME,
    p.lastName AS FACULTY_LAST_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
   -- T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
	sal.salutationName AS SALUTATION_NAME,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
	T1.reasonForSubstituteSession AS SUBSTITUTE_REASON
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    students T2 ON T2.userId = T1.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    persons T5 ON T5.id = T2.personId
        LEFT JOIN
    salutations sal ON sal.id = T5.salutationId
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
       LEFT JOIN
    staffs s ON s.userId = T1.facultyId
       LEFT JOIN
    persons p ON p.id = s.personId
       LEFT JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
       LEFT JOIN
    persons oldp ON oldp.id = olds.personId
       LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
	LEFT JOIN
    fire_base_persons_info f ON f.userId = T2.userId
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@ttfDtProviderId;
    
    
    
    UPDATE `sql_dtprovider` SET `jsonString`='{
 "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "SESSION_DATE",
            "resultKey": "SESSION_DATE",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 8,
            "value": "SLOT_FROM",
            "resultKey": "SLOT_FROM",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "SLOT_TO",
            "resultKey": "SLOT_TO",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "firstName",
            "resultKey": "FACULTY_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "lastName",
            "resultKey": "FACULTY_LAST_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "courseCodeToBePrinted",
            "resultKey": "COURSE_CODE",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "nameToBePrinted",
            "resultKey": "COURSE_NAME_TO_BE_PRINTED",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "resourceName",
            "resultKey": "ROOM_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "reasonForSubstituteSession",
            "resultKey": "SUBSTITUTE_REASON",
            "displayCode": "",
            "displayOrder": 15
        }
    ]}' WHERE `dataProviderId`=@ttfDtProviderId;

END IF;

IF EXISTS ((SELECT id FROM msg_template_config WHERE `code`='Time Table Delete For Student')) THEN

SET @addUserId=(SELECT id FROM msg_template_config WHERE `code`='Time Table Delete For Student');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;$recipientData[&quot;SALUTATION_NAME&quot;]&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]&nbsp;</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Timetable for the $recipientData[&quot;COURSE_NAME_TO_BE_PRINTED&quot;] of $recipientData[&quot;SESSION_DATE&quot;] $recipientData[&quot;SLOT_FROM&quot;] $recipientData[&quot;SLOT_TO&quot;] and $recipientData[&quot;FACULTY_FIRST_NAME&quot;] $recipientData[&quot;FACULTY_LAST_NAME&quot;] in $recipientData[&quot;ROOM_NAME&quot;] has been cancelled, because of the reason mention below: <br>
$recipientData["SUBSTITUTE_REASON"] <br><br>
Regards <br>
$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]
            </span></span></p>

			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="https://www.serosoft.com/mailer/academiaerp-logo-red.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`=@addUserId and `msgDeliveryModeId` in (1,4);

UPDATE `msg_template` SET `msgContent`='Dear $recipientData[&quot;SALUTATION_NAME&quot;] $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;], Timetable for the $recipientData[&quot;COURSE_NAME_TO_BE_PRINTED&quot;] of $recipientData[&quot;SESSION_DATE&quot;] $recipientData[&quot;SLOT_FROM&quot;] $recipientData[&quot;SLOT_TO&quot;] and $recipientData[&quot;FACULTY_FIRST_NAME&quot;] $recipientData[&quot;FACULTY_LAST_NAME&quot;] in $recipientData[&quot;ROOM_NAME&quot;] has been cancelled, because of the reason: $recipientData["SUBSTITUTE_REASON"].' WHERE `msgTemplateConfigId`=@addUserId and `msgDeliveryModeId` in (2,6);

END IF;

IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_UPDATE_FOR_FATHER_RCPNT')) THEN
SET @ttfDtProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_UPDATE_FOR_FATHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FACULTY_FIRST_NAME,
    p.lastName AS FACULTY_LAST_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    oldp.firstName AS OLD_FACULTY_FIRST_NAME,
    oldp.lastName AS OLD_FACULTY_LAST_NAME,
    oldc.courseCodeToBePrinted AS OLD_COURSE_CODE,
    oldc.nameToBePrinted AS OLD_COURSE_NAME_TO_BE_PRINTED,
    oldr.resourceName AS OLD_ROOM_NAME,
    DATE_FORMAT(T1.oldSessionDate, '%d-%m-%Y') AS OLD_SESSION_DATE,
    DATE_FORMAT(T1.oldSlotFrom, '%h:%i %p') AS OLD_SLOT_FROM,
    DATE_FORMAT(T1.oldSlotTo, '%h:%i %p') AS OLD_SLOT_TO,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    sal.salutationName AS SALUTATION_NAME,
	(select group_concat(distinct deviceTokenId) from fire_base_persons_info f where ps.userId = f.userId)  AS DEVICE_ID
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    students T2 ON T2.userId = T1.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    persons T5 ON T5.id = T2.personId
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
      LEFT  JOIN
    staffs s ON s.userId = T1.facultyId
       LEFT JOIN
    persons p ON p.id = s.personId
       LEFT JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
       LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    person_relationships AS pr ON pr.personId = T5.id
        INNER JOIN
    persons AS T7 ON T7.id = pr.relatedPersonId
  		LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN
	parents ps on ps.personId = T7.id
WHERE
    T1.id IN (namedParams) AND pr.relationship = 'FATHER'" WHERE `dataProviderId`=@ttfDtProviderId;
END IF;

IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_UPDATE_FOR_MOTHER_RCPNT')) THEN

SET @ttfDtProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_UPDATE_FOR_MOTHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FACULTY_FIRST_NAME,
    p.lastName AS FACULTY_LAST_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    oldp.firstName AS OLD_FACULTY_FIRST_NAME,
    oldp.lastName AS OLD_FACULTY_LAST_NAME,
    oldc.courseCodeToBePrinted AS OLD_COURSE_CODE,
    oldc.nameToBePrinted AS OLD_COURSE_NAME_TO_BE_PRINTED,
    oldr.resourceName AS OLD_ROOM_NAME,
    DATE_FORMAT(T1.oldSessionDate, '%d-%m-%Y') AS OLD_SESSION_DATE,
    DATE_FORMAT(T1.oldSlotFrom, '%h:%i %p') AS OLD_SLOT_FROM,
    DATE_FORMAT(T1.oldSlotTo, '%h:%i %p') AS OLD_SLOT_TO,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    sal.salutationName AS SALUTATION_NAME,
	(select group_concat(distinct deviceTokenId) from fire_base_persons_info f where ps.userId = f.userId)  AS DEVICE_ID
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    students T2 ON T2.userId = T1.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    persons T5 ON T5.id = T2.personId
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
       LEFT JOIN
    staffs s ON s.userId = T1.facultyId
       LEFT JOIN
    persons p ON p.id = s.personId
      LEFT  JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
       LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    person_relationships AS pr ON pr.personId = T5.id
        INNER JOIN
    persons AS T7 ON T7.id = pr.relatedPersonId
  		LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN
	parents ps on ps.personId = T7.id
WHERE
    T1.id IN (namedParams) AND pr.relationship = 'MOTHER'" WHERE `dataProviderId`=@ttfDtProviderId;

END IF;

set sql_safe_updates=1;

END $$

-- Execute the stored procedure
CALL V202001071912__Update_TIME_TABLE_DELETE_FOR_MOTHER_RCPNT() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001071912__Update_TIME_TABLE_DELETE_FOR_MOTHER_RCPNT $$
 
DELIMITER ;
